/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.condition;

import com.baomidou.mybatisplus.core.override.MybatisMapperProxy;
import com.tangzc.mpe.condition.metadata.DynamicConditionDescription;
import com.tangzc.mpe.condition.metadata.annotation.DynamicCondition;
import com.tangzc.mpe.magic.util.TableColumnNameUtil;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class DynamicConditionManager {
    private static final Logger log = LoggerFactory.getLogger(DynamicConditionManager.class);
    private static final Map<String, Map<String, List<DynamicConditionDescription>>> DYN_CON_CACHE = new HashMap<String, Map<String, List<DynamicConditionDescription>>>();

    public static void add(Class<?> entityClass, Field field, DynamicCondition dynamicCondition) {
        String tableName = TableColumnNameUtil.getTableName(entityClass);
        List dynamicConditionDescriptions = DYN_CON_CACHE.computeIfAbsent(tableName, $ -> new HashMap()).computeIfAbsent(entityClass.getName(), $ -> new ArrayList());
        dynamicConditionDescriptions.add(new DynamicConditionDescription(entityClass, field, dynamicCondition));
    }

    public static List<DynamicConditionDescription> getDynamicCondition(String tableName) {
        Map<String, List<DynamicConditionDescription>> row = DYN_CON_CACHE.get(tableName);
        if (row == null) {
            return Collections.emptyList();
        }
        if (row.size() == 1) {
            return row.values().stream().findFirst().get();
        }
        try {
            StackTraceElement[] stackTrace = new RuntimeException().getStackTrace();
            String mapperProxyClassName = null;
            for (int i = 0; i < stackTrace.length; ++i) {
                if (!MybatisMapperProxy.class.getName().equals(stackTrace[i].getClassName())) continue;
                mapperProxyClassName = stackTrace[i + 1].getClassName();
                break;
            }
            if (!StringUtils.hasText(mapperProxyClassName)) {
                throw new RuntimeException("\u672a\u627e\u5230\u6267\u884c\u64cd\u4f5c\u7684Mapper\u7c7b\u3002");
            }
            Class mapperClass = (Class)Class.forName(mapperProxyClassName).getGenericInterfaces()[0];
            String entityClass = DynamicConditionManager.getEntityClass(mapperClass);
            if (entityClass == null) {
                throw new RuntimeException("\u627e\u5230\u4e86Mapper\u4f46\u662f\u672a\u627e\u5230Mapper\u4e0a\u7684\u5b9e\u4f53\u3002");
            }
            return row.get(entityClass);
        }
        catch (Exception e) {
            throw new RuntimeException("\u52a8\u6001\u6761\u4ef6\uff0c\u591a\u4e2a\u5b9e\u4f53\u6620\u5c04\u4e00\u4e2a\u8868\u7684\u60c5\u51b5\u4e0b\uff0c\u672a\u627e\u5230\u5f53\u524d\u67e5\u8be2\u7684\u5b9e\u4f53\u3002", e);
        }
    }

    private static <ENTITY> String getEntityClass(Class<ENTITY> mapperClass) {
        try {
            ParameterizedType genericType;
            Type[] superTypes;
            Type[] types = mapperClass.getGenericInterfaces();
            if (types.length > 0 && types[0] != null && (superTypes = (genericType = (ParameterizedType)types[0]).getActualTypeArguments()) != null && superTypes.length > 0 && superTypes[0] != null) {
                return superTypes[0].getTypeName();
            }
        }
        catch (Exception e) {
            log.warn("\u89e3\u6790Mapper({})\u6cdb\u578b\u4e0a\u7684Entity\u51fa\u9519", mapperClass);
        }
        return null;
    }
}

