/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.datasource;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.tangzc.mpe.base.MapperScanner;
import com.tangzc.mpe.base.event.EntityUpdateEvent;
import com.tangzc.mpe.datasource.annotation.DataSource;
import com.tangzc.mpe.datasource.description.DataSourceConditionDescription;
import com.tangzc.mpe.datasource.description.WaitUpdateDescription;
import com.tangzc.mpe.datasource.description.WaitUpdateFieldDescription;
import com.tangzc.mpe.magic.util.BeanClassUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.util.StringUtils;

public class DataSourceManager {
    private static final Logger log = LoggerFactory.getLogger(DataSourceManager.class);
    private static final Map<String, Map<DescriptionSignature, WaitUpdateDescription>> ENTITY_GROUP_CACHE_MAP = new HashMap<String, Map<DescriptionSignature, WaitUpdateDescription>>();
    private static final Map<String, Map<String, Method>> ENTITY_FIELD_METHOD_CACHE_MAP = new HashMap<String, Map<String, Method>>();

    public static void addDataSource(Class<?> entityClass, Field entityField, DataSource dataSource) {
        Class sourceClass = dataSource.source();
        if (!StringUtils.hasText((String)dataSource.sourceName()) && sourceClass == Void.class) {
            log.error("{}\u7c7b\u4e0a\u7684{}\u5b57\u6bb5\uff0c@DataSource\u7f3a\u5c11`source`\u6216`sourceName`\u5c5e\u6027\uff0c\u81ea\u52a8\u66f4\u65b0\u6570\u636e\u529f\u80fd\u5c06\u88ab\u5ffd\u7565", entityClass, (Object)entityField.getName());
            return;
        }
        String sourceName = dataSource.sourceName();
        if (!StringUtils.hasText((String)sourceName)) {
            sourceName = sourceClass.getName();
        }
        DescriptionSignature descriptionSignature = new DescriptionSignature(entityClass, sourceClass, Arrays.stream(dataSource.conditions()).map(con -> new ConditionSignature(con.selfField(), con.sourceField())).collect(Collectors.toList()), dataSource.updateCondition());
        WaitUpdateDescription waitUpdateDescription = ENTITY_GROUP_CACHE_MAP.computeIfAbsent(sourceName, k -> new HashMap(4)).computeIfAbsent(descriptionSignature, k -> {
            List<DataSourceConditionDescription> conditionDescriptions = Arrays.stream(dataSource.conditions()).map(con -> {
                Field selfField = BeanClassUtil.getField((Class)entityClass, (String)con.selfField());
                Field sourceField = BeanClassUtil.getField((Class)sourceClass, (String)con.sourceField());
                return new DataSourceConditionDescription(selfField, sourceField);
            }).collect(Collectors.toList());
            return new WaitUpdateDescription(entityClass, sourceClass, dataSource.updateCondition(), conditionDescriptions, new ArrayList<WaitUpdateFieldDescription>());
        });
        Field sourceField = BeanClassUtil.getField((Class)sourceClass, (String)dataSource.field());
        waitUpdateDescription.getWaitUpdateFields().add(new WaitUpdateFieldDescription(entityField, sourceField));
    }

    @EventListener
    public void onApplicationEvent(EntityUpdateEvent<?> entityUpdateEvent) {
        Map<DescriptionSignature, WaitUpdateDescription> waitUpdateEntityDescGroupByCondition = ENTITY_GROUP_CACHE_MAP.get(entityUpdateEvent.getEntityName());
        if (waitUpdateEntityDescGroupByCondition == null) {
            return;
        }
        for (WaitUpdateDescription waitUpdateDescription : waitUpdateEntityDescGroupByCondition.values()) {
            this.executeUpdate(entityUpdateEvent, waitUpdateDescription);
        }
    }

    private <E> void executeUpdate(EntityUpdateEvent<?> entityUpdateEvent, WaitUpdateDescription waitUpdateDescription) {
        Object sourceEntity = entityUpdateEvent.getEntity();
        UpdateWrapper updateWrapper = null;
        for (WaitUpdateFieldDescription waitUpdateField : waitUpdateDescription.getWaitUpdateFields()) {
            String sourceFieldName = waitUpdateField.getSourceFieldName();
            if (!entityUpdateEvent.getFields().isEmpty() && !entityUpdateEvent.getFields().contains(sourceFieldName)) continue;
            if (updateWrapper == null) {
                updateWrapper = Wrappers.update();
            }
            try {
                Object sourceFieldVal = DataSourceManager.getFieldVal(sourceEntity, sourceFieldName);
                updateWrapper.set((Object)waitUpdateField.getEntityColumnName(), sourceFieldVal);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (updateWrapper != null) {
            for (DataSourceConditionDescription condition : waitUpdateDescription.getDataSourceConditions()) {
                try {
                    String sourceConditionFieldName = condition.getSourceFieldName();
                    Object sourceConditionFieldVal = DataSourceManager.getFieldVal(sourceEntity, sourceConditionFieldName);
                    updateWrapper.eq((Object)condition.getSelfColumnName(), sourceConditionFieldVal);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            String updateCondition = waitUpdateDescription.getUpdateCondition();
            if (StringUtils.hasText((String)updateCondition)) {
                updateWrapper.apply(updateCondition, new Object[0]);
            }
            Class<?> waitUpdateEntityClass = waitUpdateDescription.getEntityClass();
            UpdateWrapper finalUpdateWrapper = updateWrapper;
            MapperScanner.getMapperExecute(waitUpdateEntityClass, (SFunction & Serializable)mapper -> mapper.update(null, (Wrapper)finalUpdateWrapper));
        }
    }

    private static Object getFieldVal(Object sourceEntity, String sourceFieldName) throws IllegalAccessException, InvocationTargetException {
        Class<?> sourceEntityClass = sourceEntity.getClass();
        String sourceEntityClassName = sourceEntityClass.getName();
        Map sourceEntityFieldMethodCache = ENTITY_FIELD_METHOD_CACHE_MAP.computeIfAbsent(sourceEntityClassName, k -> new HashMap(1));
        Method sourceFieldReadMethod = sourceEntityFieldMethodCache.computeIfAbsent(sourceFieldName, k -> BeanClassUtil.getReadMethod((Class)sourceEntityClass, (String)sourceFieldName));
        return sourceFieldReadMethod.invoke(sourceEntity, new Object[0]);
    }

    private static class DescriptionSignature {
        private Class<?> entityClass;
        private Class<?> sourceClass;
        private List<ConditionSignature> conditions;
        private String updateCondition;

        public Class<?> getEntityClass() {
            return this.entityClass;
        }

        public Class<?> getSourceClass() {
            return this.sourceClass;
        }

        public List<ConditionSignature> getConditions() {
            return this.conditions;
        }

        public String getUpdateCondition() {
            return this.updateCondition;
        }

        public void setEntityClass(Class<?> entityClass) {
            this.entityClass = entityClass;
        }

        public void setSourceClass(Class<?> sourceClass) {
            this.sourceClass = sourceClass;
        }

        public void setConditions(List<ConditionSignature> conditions) {
            this.conditions = conditions;
        }

        public void setUpdateCondition(String updateCondition) {
            this.updateCondition = updateCondition;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DescriptionSignature)) {
                return false;
            }
            DescriptionSignature other = (DescriptionSignature)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class<?> this$entityClass = this.getEntityClass();
            Class<?> other$entityClass = other.getEntityClass();
            if (this$entityClass == null ? other$entityClass != null : !this$entityClass.equals(other$entityClass)) {
                return false;
            }
            Class<?> this$sourceClass = this.getSourceClass();
            Class<?> other$sourceClass = other.getSourceClass();
            if (this$sourceClass == null ? other$sourceClass != null : !this$sourceClass.equals(other$sourceClass)) {
                return false;
            }
            List<ConditionSignature> this$conditions = this.getConditions();
            List<ConditionSignature> other$conditions = other.getConditions();
            if (this$conditions == null ? other$conditions != null : !((Object)this$conditions).equals(other$conditions)) {
                return false;
            }
            String this$updateCondition = this.getUpdateCondition();
            String other$updateCondition = other.getUpdateCondition();
            return !(this$updateCondition == null ? other$updateCondition != null : !this$updateCondition.equals(other$updateCondition));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DescriptionSignature;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<?> $entityClass = this.getEntityClass();
            result = result * 59 + ($entityClass == null ? 43 : $entityClass.hashCode());
            Class<?> $sourceClass = this.getSourceClass();
            result = result * 59 + ($sourceClass == null ? 43 : $sourceClass.hashCode());
            List<ConditionSignature> $conditions = this.getConditions();
            result = result * 59 + ($conditions == null ? 43 : ((Object)$conditions).hashCode());
            String $updateCondition = this.getUpdateCondition();
            result = result * 59 + ($updateCondition == null ? 43 : $updateCondition.hashCode());
            return result;
        }

        public String toString() {
            return "DataSourceManager.DescriptionSignature(entityClass=" + String.valueOf(this.getEntityClass()) + ", sourceClass=" + String.valueOf(this.getSourceClass()) + ", conditions=" + String.valueOf(this.getConditions()) + ", updateCondition=" + this.getUpdateCondition() + ")";
        }

        public DescriptionSignature(Class<?> entityClass, Class<?> sourceClass, List<ConditionSignature> conditions, String updateCondition) {
            this.entityClass = entityClass;
            this.sourceClass = sourceClass;
            this.conditions = conditions;
            this.updateCondition = updateCondition;
        }
    }

    private static class ConditionSignature {
        private String selfField;
        private String sourceField;

        public String getSelfField() {
            return this.selfField;
        }

        public String getSourceField() {
            return this.sourceField;
        }

        public void setSelfField(String selfField) {
            this.selfField = selfField;
        }

        public void setSourceField(String sourceField) {
            this.sourceField = sourceField;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConditionSignature)) {
                return false;
            }
            ConditionSignature other = (ConditionSignature)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$selfField = this.getSelfField();
            String other$selfField = other.getSelfField();
            if (this$selfField == null ? other$selfField != null : !this$selfField.equals(other$selfField)) {
                return false;
            }
            String this$sourceField = this.getSourceField();
            String other$sourceField = other.getSourceField();
            return !(this$sourceField == null ? other$sourceField != null : !this$sourceField.equals(other$sourceField));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ConditionSignature;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $selfField = this.getSelfField();
            result = result * 59 + ($selfField == null ? 43 : $selfField.hashCode());
            String $sourceField = this.getSourceField();
            result = result * 59 + ($sourceField == null ? 43 : $sourceField.hashCode());
            return result;
        }

        public String toString() {
            return "DataSourceManager.ConditionSignature(selfField=" + this.getSelfField() + ", sourceField=" + this.getSourceField() + ")";
        }

        public ConditionSignature(String selfField, String sourceField) {
            this.selfField = selfField;
            this.sourceField = sourceField;
        }
    }
}

