/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.magic.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationDefaultValueHelper {
    private static final Logger log = LoggerFactory.getLogger(AnnotationDefaultValueHelper.class);

    public static <A extends Annotation> A getAnnotationWithDefaultValues(Class<A> annotationType, Consumer<Map<String, Object>> changeDefaultValues) {
        Map<String, Object> defaultValues = AnnotationDefaultValueHelper.getDefaultValues(annotationType);
        if (changeDefaultValues != null) {
            changeDefaultValues.accept(defaultValues);
        }
        return AnnotationDefaultValueHelper.createAnnotationInstance(annotationType, defaultValues);
    }

    public static <A extends Annotation> Map<String, Object> getDefaultValues(Class<A> annotationType) {
        Method[] declaredMethods;
        HashMap<String, Object> defaultValues = new HashMap<String, Object>();
        for (Method method : declaredMethods = annotationType.getDeclaredMethods()) {
            if (method.getParameterCount() != 0 || method.getReturnType() == Void.TYPE) continue;
            Object defaultValue = method.getDefaultValue();
            defaultValues.put(method.getName(), defaultValue);
        }
        return defaultValues;
    }

    public static void setAnnoVal(Annotation annotation, String fieldName, Object newVal) {
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(annotation);
        try {
            Field valuesField = invocationHandler.getClass().getDeclaredField("valueCache");
            valuesField.setAccessible(true);
            Map memberValues = (Map)valuesField.get(invocationHandler);
            memberValues.put(fieldName, newVal);
        }
        catch (Exception e) {
            log.error("\u6ce8\u89e3\u53cd\u5c04\u51fa\u9519", (Throwable)e);
        }
    }

    public static <A extends Annotation> A createAnnotationInstance(Class<A> annotationType, final Map<String, Object> values) {
        return (A)((Annotation)Proxy.newProxyInstance(annotationType.getClassLoader(), new Class[]{annotationType}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                String methodName = method.getName();
                if (values.containsKey(methodName)) {
                    return values.get(methodName);
                }
                return method.invoke((Object)this, args);
            }
        }));
    }
}

