/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.magic.util;

import com.baomidou.mybatisplus.core.toolkit.LambdaUtils;
import com.baomidou.mybatisplus.core.toolkit.support.LambdaMeta;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ibatis.reflection.property.PropertyNamer;
import org.springframework.beans.BeanUtils;

public class BeanClassUtil {
    public static <E> String getFieldName(SFunction<E, ?> sf) {
        LambdaMeta lambda = LambdaUtils.extract(sf);
        return PropertyNamer.methodToProperty((String)lambda.getImplMethodName());
    }

    public static Class<?> getFieldRealClass(Field field) {
        Type genericType;
        Class fieldClass = field.getType();
        if (Collection.class.isAssignableFrom(fieldClass) && (genericType = field.getGenericType()) instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)genericType;
            fieldClass = (Class)pt.getActualTypeArguments()[0];
        }
        return fieldClass;
    }

    public static <T> Class<?> getFieldRealClass(Class<T> clazz, SFunction<T, ?> sFunction) {
        String fieldName = BeanClassUtil.getFieldName(sFunction);
        Field field = BeanClassUtil.getField(clazz, fieldName);
        return BeanClassUtil.getFieldRealClass(field);
    }

    public static Method getWriteMethod(Class<?> clazz, Field field) {
        field.setAccessible(true);
        String fieldName = field.getName();
        return BeanClassUtil.getWriteMethod(clazz, fieldName);
    }

    public static Method getWriteMethod(Class<?> clazz, String fieldName) {
        PropertyDescriptor propertyDescriptor = BeanUtils.getPropertyDescriptor(clazz, (String)fieldName);
        if (propertyDescriptor != null && propertyDescriptor.getWriteMethod() != null) {
            return propertyDescriptor.getWriteMethod();
        }
        throw new RuntimeException(String.valueOf(clazz) + "\u4e0b\u672a\u627e\u5230" + fieldName + "\u7684set\u65b9\u6cd5");
    }

    public static Method getReadMethod(Class<?> clazz, Field field) {
        field.setAccessible(true);
        String fieldName = field.getName();
        return BeanClassUtil.getReadMethod(clazz, fieldName);
    }

    public static Method getReadMethod(Class<?> clazz, String fieldName) {
        PropertyDescriptor propertyDescriptor = BeanUtils.getPropertyDescriptor(clazz, (String)fieldName);
        if (propertyDescriptor != null && propertyDescriptor.getReadMethod() != null) {
            return propertyDescriptor.getReadMethod();
        }
        throw new RuntimeException(String.valueOf(clazz) + "\u4e0b\u672a\u627e\u5230" + fieldName + "\u7684get/is\u65b9\u6cd5");
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        Class<?> superclass;
        Field field;
        while ((field = (Field)Arrays.stream(clazz.getDeclaredFields()).filter(f -> f.getName().equals(fieldName)).findFirst().orElse(null)) == null && (superclass = clazz.getSuperclass()) != null && superclass != Object.class) {
            clazz = superclass;
        }
        if (field == null) {
            throw new RuntimeException(clazz.getName() + "\u4e0a\u6ca1\u6709\u627e\u5230\u5b57\u6bb5\uff1a" + fieldName);
        }
        return field;
    }

    public static List<Field> getAllDeclaredFieldsExcludeStatic(Class<?> beanClass) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        BeanClassUtil.getFieldList(fieldList, beanClass);
        return fieldList.stream().filter(field -> !Modifier.isStatic(field.getModifiers())).collect(Collectors.toList());
    }

    public static List<Field> getAllDeclaredFields(Class<?> beanClass) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        BeanClassUtil.getFieldList(fieldList, beanClass);
        return fieldList;
    }

    private static void getFieldList(List<Field> fields, Class<?> beanClass) {
        Field[] declaredFields = beanClass.getDeclaredFields();
        Set fieldNames = fields.stream().map(Field::getName).collect(Collectors.toSet());
        for (Field field : declaredFields) {
            if (fieldNames.contains(field.getName())) continue;
            fields.add(field);
        }
        Class<?> superclass = beanClass.getSuperclass();
        if (superclass != null) {
            BeanClassUtil.getFieldList(fields, superclass);
        }
    }
}

