/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.magic.util;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.tangzc.mpe.magic.MybatisPlusProperties;
import com.tangzc.mpe.magic.util.AnnotatedElementUtilsPlus;
import com.tangzc.mpe.magic.util.BeanClassUtil;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class TableColumnNameUtil {
    private static final Map<Class<?>, String> TABLE_NAME_CATCH = new HashMap();

    public static String filterSpecialChar(String name) {
        return name.replaceAll("`", "");
    }

    public static String getTableName(Class<?> clazz) {
        return TABLE_NAME_CATCH.computeIfAbsent(clazz, k -> {
            Object finalTableName = "";
            boolean addTablePrefix = org.springframework.util.StringUtils.hasText((String)MybatisPlusProperties.tablePrefix);
            TableName mybatisPlusTableName = AnnotatedElementUtilsPlus.findDeepMergedAnnotation(clazz, TableName.class);
            if (mybatisPlusTableName != null && org.springframework.util.StringUtils.hasText((String)mybatisPlusTableName.value())) {
                finalTableName = mybatisPlusTableName.value();
                if (addTablePrefix && !mybatisPlusTableName.keepGlobalPrefix()) {
                    addTablePrefix = false;
                }
            }
            if (!org.springframework.util.StringUtils.hasText((String)finalTableName)) {
                finalTableName = TableColumnNameUtil.smartConvert(MybatisPlusProperties.tableUnderline, clazz.getSimpleName());
            }
            if (addTablePrefix) {
                finalTableName = MybatisPlusProperties.tablePrefix + (String)finalTableName;
            }
            return finalTableName;
        });
    }

    public static String getRealColumnName(Field field) {
        TableField tableField = AnnotatedElementUtilsPlus.findDeepMergedAnnotation(field, TableField.class);
        if (tableField != null && org.springframework.util.StringUtils.hasText((String)tableField.value()) && tableField.exist()) {
            return TableColumnNameUtil.filterSpecialChar(tableField.value());
        }
        TableId tableId = AnnotatedElementUtilsPlus.findDeepMergedAnnotation(field, TableId.class);
        if (tableId != null && org.springframework.util.StringUtils.hasText((String)tableId.value())) {
            return TableColumnNameUtil.filterSpecialChar(tableId.value());
        }
        return TableColumnNameUtil.smartConvert(MybatisPlusProperties.mapUnderscoreToCamelCase, field.getName());
    }

    public static String getRealColumnName(Class<?> beanClazz, String fieldName) {
        Field field = BeanClassUtil.getField(beanClazz, fieldName);
        TableField tableField = AnnotatedElementUtilsPlus.findDeepMergedAnnotation(field, TableField.class);
        if (tableField != null && org.springframework.util.StringUtils.hasText((String)tableField.value()) && tableField.exist()) {
            return TableColumnNameUtil.filterSpecialChar(tableField.value());
        }
        TableId tableId = AnnotatedElementUtilsPlus.findDeepMergedAnnotation(field, TableId.class);
        if (tableId != null && org.springframework.util.StringUtils.hasText((String)tableId.value())) {
            return TableColumnNameUtil.filterSpecialChar(tableId.value());
        }
        return TableColumnNameUtil.smartConvert(MybatisPlusProperties.mapUnderscoreToCamelCase, field.getName());
    }

    private static String smartConvert(boolean underCamel, String column) {
        if (underCamel) {
            column = StringUtils.camelToUnderline((String)column);
        }
        if (MybatisPlusProperties.capitalMode) {
            column = column.toUpperCase();
        }
        return column;
    }
}

