/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.processer;

import com.google.auto.service.AutoService;
import com.tangzc.mpe.processer.annotation.AutoDefine;
import com.tangzc.mpe.processer.annotation.AutoMapper;
import com.tangzc.mpe.processer.annotation.AutoRepository;
import com.tangzc.mpe.processer.builder.DefineBuilder;
import com.tangzc.mpe.processer.builder.MapperBuilder;
import com.tangzc.mpe.processer.builder.RepositoryBuilder;
import com.tangzc.mpe.processer.config.MybatisPlusExtProcessConfig;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

@AutoService(value={Processor.class})
public class AutoBuildProcessor
extends AbstractProcessor {
    private DefineBuilder defineBuilder;
    private MapperBuilder mapperBuilder;
    private RepositoryBuilder repositoryBuilder;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        Types typeUtils = processingEnv.getTypeUtils();
        Elements elementUtils = processingEnv.getElementUtils();
        Filer filer = processingEnv.getFiler();
        Messager messager = processingEnv.getMessager();
        MybatisPlusExtProcessConfig mybatisPlusExtProcessConfig = new MybatisPlusExtProcessConfig(filer);
        this.defineBuilder = new DefineBuilder(filer, messager, typeUtils, elementUtils, mybatisPlusExtProcessConfig);
        this.mapperBuilder = new MapperBuilder(filer, messager, typeUtils, elementUtils, mybatisPlusExtProcessConfig);
        this.repositoryBuilder = new RepositoryBuilder(filer, messager, typeUtils, elementUtils, mybatisPlusExtProcessConfig, this.mapperBuilder);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annoations, RoundEnvironment env) {
        TypeElement classElement;
        if (annoations.isEmpty()) {
            return true;
        }
        for (Element element : env.getElementsAnnotatedWith(AutoDefine.class)) {
            if (element.getKind() != ElementKind.CLASS) continue;
            classElement = (TypeElement)element;
            this.defineBuilder.buildDefine(classElement);
        }
        for (Element element : env.getElementsAnnotatedWith(AutoMapper.class)) {
            if (element.getKind() != ElementKind.CLASS) continue;
            classElement = (TypeElement)element;
            this.mapperBuilder.buildMapper(classElement);
        }
        for (Element element : env.getElementsAnnotatedWith(AutoRepository.class)) {
            if (element.getKind() != ElementKind.CLASS) continue;
            classElement = (TypeElement)element;
            this.repositoryBuilder.buildRepository(classElement);
        }
        return true;
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> supportedAnnotations = new HashSet<String>();
        supportedAnnotations.add(AutoMapper.class.getCanonicalName());
        supportedAnnotations.add(AutoRepository.class.getCanonicalName());
        return supportedAnnotations;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }
}

