/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.processer.builder;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import com.tangzc.mpe.autotable.annotation.Table;
import java.io.IOException;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.springframework.util.StringUtils;

public abstract class BaseBuilder {
    protected final Filer filer;
    protected final Messager messager;

    protected BaseBuilder(Filer filer, Messager messager) {
        this.filer = filer;
        this.messager = messager;
    }

    protected void addDsAnnotation(TypeElement element, TypeSpec.Builder builder) {
        Table table = element.getAnnotation(Table.class);
        if (table != null && StringUtils.hasText((String)table.dsName())) {
            AnnotationSpec.Builder dsAnnotationBuilder = AnnotationSpec.builder((ClassName)ClassName.get(DS.class));
            dsAnnotationBuilder.addMember("value", CodeBlock.of((String)"$S", (Object[])new Object[]{table.dsName()}));
            AnnotationSpec dsAnnotation = dsAnnotationBuilder.build();
            builder.addAnnotation(dsAnnotation);
        }
    }

    protected String getTargetPackageName(String entityPackagePath, String customPackagePath) {
        String packageName = entityPackagePath;
        if (!"".equals(customPackagePath)) {
            if (customPackagePath.startsWith(".")) {
                customPackagePath = customPackagePath.substring(1);
                String basePackageName = entityPackagePath;
                while (customPackagePath.startsWith(".")) {
                    customPackagePath = customPackagePath.substring(1);
                    int lastIndexOfPoint = basePackageName.lastIndexOf(".");
                    if (lastIndexOfPoint != -1) {
                        basePackageName = basePackageName.substring(0, lastIndexOfPoint);
                        continue;
                    }
                    basePackageName = "";
                }
                if (!customPackagePath.isEmpty() && !basePackageName.isEmpty()) {
                    customPackagePath = "." + customPackagePath;
                }
                packageName = basePackageName + customPackagePath;
            } else {
                packageName = customPackagePath;
            }
        }
        return packageName;
    }

    protected String getTargetName(String customName, String entityName, String suffix) {
        String name = !"".equals(customName) ? customName : entityName + suffix;
        return name;
    }

    protected void writeToFile(JavaFile javaFile) {
        try {
            if (javaFile != null) {
                javaFile.writeTo(this.filer);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void log(String msg) {
        this.messager.printMessage(Diagnostic.Kind.NOTE, msg);
    }
}

