/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.processer.builder;

import com.tangzc.mpe.processer.annotation.AutoDefine;
import com.tangzc.mpe.processer.builder.BaseBuilder;
import com.tangzc.mpe.processer.config.ConfigurationKey;
import com.tangzc.mpe.processer.config.MybatisPlusExtProcessConfig;
import java.io.PrintWriter;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.JavaFileObject;

public class DefineBuilder
extends BaseBuilder {
    private final Types typeUtils;
    private final Elements elementUtils;
    private final MybatisPlusExtProcessConfig mybatisPlusExtProcessConfig;

    public DefineBuilder(Filer filer, Messager messager, Types typeUtils, Elements elementUtils, MybatisPlusExtProcessConfig mybatisPlusExtProcessConfig) {
        super(filer, messager);
        this.typeUtils = typeUtils;
        this.elementUtils = elementUtils;
        this.mybatisPlusExtProcessConfig = mybatisPlusExtProcessConfig;
    }

    public void buildDefine(TypeElement classElement) {
        Set fields = classElement.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.FIELD && !e.getModifiers().contains((Object)Modifier.STATIC)).map(e -> e.getSimpleName().toString()).collect(Collectors.toSet());
        TypeMirror superClassMirror = classElement.getSuperclass();
        while (!superClassMirror.toString().equals(Object.class.getName())) {
            TypeElement superClassElement = (TypeElement)this.typeUtils.asElement(superClassMirror);
            fields.addAll(superClassElement.getEnclosedElements().stream().filter(e -> {
                Set<Modifier> modifiers = e.getModifiers();
                return e.getKind() == ElementKind.FIELD && modifiers.contains((Object)Modifier.PROTECTED) && !modifiers.contains((Object)Modifier.STATIC);
            }).map(e -> e.getSimpleName().toString()).collect(Collectors.toSet()));
            superClassMirror = superClassElement.getSuperclass();
        }
        AutoDefine autoDefine = classElement.getAnnotation(AutoDefine.class);
        String suffix = autoDefine.suffix();
        if (suffix.isEmpty()) {
            suffix = this.mybatisPlusExtProcessConfig.get(ConfigurationKey.ENTITY_DEFINE_SUFFIX);
        }
        String className = classElement.getSimpleName().toString() + suffix;
        String packageName = autoDefine.packageName();
        if (packageName.isEmpty()) {
            packageName = this.mybatisPlusExtProcessConfig.get(ConfigurationKey.ENTITY_DEFINE_PACKAGE_NAME);
        }
        String entityPackageName = this.elementUtils.getPackageOf(classElement).getQualifiedName().toString();
        packageName = this.getTargetPackageName(entityPackageName, packageName);
        try {
            JavaFileObject file = this.filer.createSourceFile(packageName + "." + className, new Element[0]);
            try (PrintWriter writer = new PrintWriter(file.openWriter());){
                writer.println("package " + packageName + ";");
                writer.println();
                writer.println("public interface " + className + " {");
                for (String field : fields) {
                    writer.println("    String " + field + " = \"" + field + "\";");
                }
                writer.println("}");
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }
}

