/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.processer.builder;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.tangzc.mpe.processer.annotation.AutoMapper;
import com.tangzc.mpe.processer.builder.BaseBuilder;
import com.tangzc.mpe.processer.config.ConfigurationKey;
import com.tangzc.mpe.processer.config.MybatisPlusExtProcessConfig;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.apache.ibatis.annotations.Mapper;

public class MapperBuilder
extends BaseBuilder {
    private final Types typeUtils;
    private final Elements elementUtils;
    private final MybatisPlusExtProcessConfig mybatisPlusExtProcessConfig;

    public MapperBuilder(Filer filer, Messager messager, Types typeUtils, Elements elementUtils, MybatisPlusExtProcessConfig mybatisPlusExtProcessConfig) {
        super(filer, messager);
        this.typeUtils = typeUtils;
        this.elementUtils = elementUtils;
        this.mybatisPlusExtProcessConfig = mybatisPlusExtProcessConfig;
    }

    public void buildMapper(TypeElement classElement) {
        AutoMapper autoMapper = classElement.getAnnotation(AutoMapper.class);
        this.buildMapper(classElement, autoMapper);
    }

    public String buildMapper(TypeElement element, AutoMapper autoMapper) {
        String entityPackageName = this.elementUtils.getPackageOf(element).getQualifiedName().toString();
        String entityName = element.getSimpleName().toString();
        String suffix = this.getMapperSuffix(autoMapper);
        String mapperName = this.getTargetName(autoMapper.value(), entityName, suffix);
        String packageName = this.getMapperPackageName(autoMapper);
        String mapperPackagePath = this.getTargetPackageName(entityPackageName, packageName);
        ClassName mapperSuperclassName = this.getMapperSuperclassName(autoMapper);
        TypeSpec.Builder builder = TypeSpec.interfaceBuilder((String)mapperName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)mapperSuperclassName, (TypeName[])new TypeName[]{ClassName.get((String)entityPackageName, (String)entityName, (String[])new String[0])})).addAnnotation(ClassName.get(Mapper.class));
        if (autoMapper.withDSAnnotation()) {
            this.addDsAnnotation(element, builder);
        }
        TypeSpec mapper = builder.build();
        JavaFile javaFile = JavaFile.builder((String)mapperPackagePath, (TypeSpec)mapper).build();
        this.writeToFile(javaFile);
        return mapperPackagePath + "." + mapperName;
    }

    private ClassName getMapperSuperclassName(AutoMapper autoMapper) {
        ClassName mapperSuperclassName = ClassName.get(BaseMapper.class);
        String baseMapperClassName = autoMapper.superclassName();
        if (baseMapperClassName.isEmpty()) {
            baseMapperClassName = this.mybatisPlusExtProcessConfig.get(ConfigurationKey.MAPPER_SUPERCLASS_NAME);
        }
        if (!baseMapperClassName.isEmpty()) {
            int lastIndexOf = baseMapperClassName.lastIndexOf(".");
            String baseMapperPackageName = baseMapperClassName.substring(0, lastIndexOf);
            String baseMapperName = baseMapperClassName.substring(lastIndexOf + 1);
            mapperSuperclassName = ClassName.get((String)baseMapperPackageName, (String)baseMapperName, (String[])new String[0]);
        }
        return mapperSuperclassName;
    }

    public String getMapperPackageName(AutoMapper autoMapper) {
        String packageName = autoMapper.packageName();
        if (packageName.isEmpty()) {
            packageName = this.mybatisPlusExtProcessConfig.get(ConfigurationKey.MAPPER_PACKAGE_NAME);
        }
        return packageName;
    }

    public String getMapperSuffix(AutoMapper autoMapper) {
        String suffix = autoMapper.suffix();
        if ("".equals(suffix)) {
            suffix = this.mybatisPlusExtProcessConfig.get(ConfigurationKey.MAPPER_SUFFIX);
        }
        return suffix;
    }
}

