/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.processer.builder;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.tangzc.mpe.base.repository.BaseRepository;
import com.tangzc.mpe.processer.annotation.AutoMapper;
import com.tangzc.mpe.processer.annotation.AutoRepository;
import com.tangzc.mpe.processer.builder.BaseBuilder;
import com.tangzc.mpe.processer.builder.MapperBuilder;
import com.tangzc.mpe.processer.config.ConfigurationKey;
import com.tangzc.mpe.processer.config.MybatisPlusExtProcessConfig;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.springframework.stereotype.Repository;

public class RepositoryBuilder
extends BaseBuilder {
    private final Types typeUtils;
    private final Elements elementUtils;
    private final MybatisPlusExtProcessConfig mybatisPlusExtProcessConfig;
    private final MapperBuilder mapperBuilder;

    public RepositoryBuilder(Filer filer, Messager messager, Types typeUtils, Elements elementUtils, MybatisPlusExtProcessConfig mybatisPlusExtProcessConfig, MapperBuilder mapperBuilder) {
        super(filer, messager);
        this.typeUtils = typeUtils;
        this.elementUtils = elementUtils;
        this.mybatisPlusExtProcessConfig = mybatisPlusExtProcessConfig;
        this.mapperBuilder = mapperBuilder;
    }

    public void buildRepository(TypeElement element) {
        String mapperPackageName;
        String mapperName;
        String entityPackageName = this.elementUtils.getPackageOf(element).getQualifiedName().toString();
        String entityName = element.getSimpleName().toString();
        AutoRepository autoRepository = element.getAnnotation(AutoRepository.class);
        String suffix = autoRepository.suffix();
        if ("".equals(suffix)) {
            suffix = this.mybatisPlusExtProcessConfig.get(ConfigurationKey.REPOSITORY_SUFFIX);
        }
        String repositoryName = this.getTargetName(autoRepository.value(), entityName, suffix);
        String customPackageName = autoRepository.packageName();
        if (customPackageName.isEmpty()) {
            customPackageName = this.mybatisPlusExtProcessConfig.get(ConfigurationKey.REPOSITORY_PACKAGE_NAME);
        }
        String repositoryPackageName = this.getTargetPackageName(entityPackageName, customPackageName);
        AutoMapper autoMapper = element.getAnnotation(AutoMapper.class);
        if (autoMapper != null) {
            mapperName = this.getTargetName(autoMapper.value(), entityName, this.mapperBuilder.getMapperSuffix(autoMapper));
            mapperPackageName = this.getTargetPackageName(entityPackageName, this.mapperBuilder.getMapperPackageName(autoMapper));
        } else {
            autoMapper = autoRepository.autoMapper();
            String fullMapperName = this.mapperBuilder.buildMapper(element, autoMapper);
            int lastIndexOfPoint = fullMapperName.lastIndexOf(".");
            mapperName = fullMapperName.substring(lastIndexOfPoint + 1);
            mapperPackageName = fullMapperName.substring(0, lastIndexOfPoint);
        }
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)repositoryName).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(BaseRepository.class), (TypeName[])new TypeName[]{ClassName.get((String)mapperPackageName, (String)mapperName, (String[])new String[0]), ClassName.get((String)entityPackageName, (String)entityName, (String[])new String[0])})).addAnnotation(ClassName.get(Repository.class));
        if (autoRepository.withDSAnnotation()) {
            this.addDsAnnotation(element, builder);
        }
        TypeSpec repository = builder.build();
        JavaFile javaFile = JavaFile.builder((String)repositoryPackageName, (TypeSpec)repository).build();
        this.writeToFile(javaFile);
    }
}

