/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.processer.config;

import com.tangzc.mpe.processer.config.ConfigurationKey;
import com.tangzc.mpe.processer.config.FileUtil;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Properties;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

public class MybatisPlusExtProcessConfig {
    private static final String APT_FILE_NAME = "mybatis-plus-ext.config";
    protected final Properties properties = new Properties();

    public MybatisPlusExtProcessConfig(Filer filer) {
        try {
            File classPathFile;
            FileObject resource = filer.createResource(StandardLocation.CLASS_OUTPUT, "", "mybatis-plus-ext", new Element[0]);
            String projectRootPath = FileUtil.getProjectRootPath(classPathFile, 10);
            ArrayList<File> aptConfigFiles = new ArrayList<File>();
            for (classPathFile = new File(resource.toUri()).getParentFile(); projectRootPath != null && classPathFile != null && projectRootPath.length() <= classPathFile.getAbsolutePath().length(); classPathFile = classPathFile.getParentFile()) {
                File aptConfig = new File(classPathFile, APT_FILE_NAME);
                if (!aptConfig.exists()) continue;
                aptConfigFiles.add(aptConfig);
            }
            for (File aptConfigFile : aptConfigFiles) {
                InputStream stream = Files.newInputStream(aptConfigFile.toPath(), new OpenOption[0]);
                try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
                    Properties config = new Properties();
                    config.load(reader);
                    boolean stopBubbling = false;
                    for (Object key : config.keySet()) {
                        if (!this.properties.containsKey(key)) {
                            this.properties.put(key, config.getProperty((String)key));
                        }
                        if (!"processor.stopBubbling".equalsIgnoreCase((String)key) || !"true".equalsIgnoreCase(String.valueOf(config.getProperty((String)key)))) continue;
                        stopBubbling = true;
                    }
                    if (!stopBubbling) continue;
                    break;
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String get(ConfigurationKey key) {
        return this.properties.getProperty(key.getConfigKey(), key.getDefaultValue());
    }
}

