/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.processer.builder;

import com.tangzc.mpe.processer.annotation.AutoDefine;
import com.tangzc.mpe.processer.builder.BaseBuilder;
import com.tangzc.mpe.processer.config.ConfigurationKey;
import com.tangzc.mpe.processer.config.MybatisPlusExtProcessConfig;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class DefineBuilder
extends BaseBuilder {
    private final Types typeUtils;

    public DefineBuilder(Filer filer, Messager messager, Types typeUtils, Elements elementUtils, MybatisPlusExtProcessConfig mybatisPlusExtProcessConfig) {
        super(filer, messager, elementUtils, mybatisPlusExtProcessConfig);
        this.typeUtils = typeUtils;
    }

    public void buildDefine(TypeElement classElement, AutoDefine autoDefine) {
        String suffix = this.getValueOrDefault(autoDefine.suffix(), ConfigurationKey.ENTITY_DEFINE_SUFFIX);
        String defineName = classElement.getSimpleName().toString() + suffix;
        String packageName = this.getValueOrDefault(autoDefine.packageName(), ConfigurationKey.ENTITY_DEFINE_PACKAGE_NAME);
        String definePackageName = this.getTargetPackageName(classElement, packageName);
        if (this.isExist(definePackageName, defineName)) {
            return;
        }
        Set fields = classElement.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.FIELD && !e.getModifiers().contains((Object)Modifier.STATIC)).map(e -> e.getSimpleName().toString()).collect(Collectors.toSet());
        String strictExtends = this.mybatisPlusExtProcessConfig.get(ConfigurationKey.ENTITY_DEFINE_STRICT_EXTENDS);
        boolean isStrictExtends = "true".equalsIgnoreCase(strictExtends) || "on".equalsIgnoreCase(strictExtends);
        TypeMirror superClassMirror = classElement.getSuperclass();
        while (!superClassMirror.toString().equals(Object.class.getName())) {
            TypeElement superClassElement = (TypeElement)this.typeUtils.asElement(superClassMirror);
            fields.addAll(superClassElement.getEnclosedElements().stream().filter(e -> {
                Set<Modifier> modifiers = e.getModifiers();
                return e.getKind() == ElementKind.FIELD && (!isStrictExtends || modifiers.contains((Object)Modifier.PROTECTED) || modifiers.contains((Object)Modifier.PUBLIC)) && !modifiers.contains((Object)Modifier.STATIC);
            }).map(e -> e.getSimpleName().toString()).collect(Collectors.toSet()));
            superClassMirror = superClassElement.getSuperclass();
        }
        List<String> lines = Arrays.asList("package " + definePackageName + ";", "", "public interface " + defineName + " {", fields.stream().map(field -> "    String " + field + " = \"" + field + "\";").collect(Collectors.joining("\n")), "}");
        this.writeToFile(definePackageName + "." + defineName, lines);
    }
}

