/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.processer.builder;

import com.tangzc.mpe.autotable.annotation.Table;
import com.tangzc.mpe.processer.annotation.AutoRepository;
import com.tangzc.mpe.processer.builder.BaseBuilder;
import com.tangzc.mpe.processer.builder.MapperBuilder;
import com.tangzc.mpe.processer.config.ConfigurationKey;
import com.tangzc.mpe.processer.config.MybatisPlusExtProcessConfig;
import java.util.Arrays;
import java.util.List;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class RepositoryBuilder
extends BaseBuilder {
    private final Elements elementUtils;
    private final MybatisPlusExtProcessConfig mybatisPlusExtProcessConfig;

    public RepositoryBuilder(Filer filer, Messager messager, Types typeUtils, Elements elementUtils, MybatisPlusExtProcessConfig mybatisPlusExtProcessConfig, MapperBuilder mapperBuilder) {
        super(filer, messager, elementUtils, mybatisPlusExtProcessConfig);
        this.elementUtils = elementUtils;
        this.mybatisPlusExtProcessConfig = mybatisPlusExtProcessConfig;
    }

    public void buildRepository(TypeElement element, AutoRepository autoRepository, String fullMapperName) {
        String repositoryPackageName;
        String entityPackageName = this.elementUtils.getPackageOf(element).getQualifiedName().toString();
        String entityName = element.getSimpleName().toString();
        String suffix = autoRepository.suffix();
        if ("".equals(suffix)) {
            suffix = this.mybatisPlusExtProcessConfig.get(ConfigurationKey.REPOSITORY_SUFFIX);
        }
        String repositoryName = this.getTargetName(autoRepository.value(), entityName, suffix);
        String customPackageName = autoRepository.packageName();
        if (customPackageName.isEmpty()) {
            customPackageName = this.mybatisPlusExtProcessConfig.get(ConfigurationKey.REPOSITORY_PACKAGE_NAME);
        }
        if (this.isExist(repositoryPackageName = this.getTargetPackageName(element, customPackageName), repositoryName)) {
            return;
        }
        int endIndex = fullMapperName.lastIndexOf(".");
        String mapperPackageName = fullMapperName.substring(0, endIndex);
        String mapperName = fullMapperName.substring(endIndex + 1);
        String dsAnnoImport = null;
        String dsAnno = null;
        if (autoRepository.withDSAnnotation()) {
            Table table = element.getAnnotation(Table.class);
            if (table != null) {
                dsAnnoImport = "import com.baomidou.dynamic.datasource.annotation.DS;";
                dsAnno = "@DS(\"" + table.dsName() + "\")";
            } else {
                this.warn(entityPackageName + "." + entityName + "\u7f3a\u5c11@Table\u7684dsName\u914d\u7f6e\uff0c\u65e0\u6cd5\u4e3a" + repositoryPackageName + "." + repositoryName + "\u6dfb\u52a0@DS ");
            }
        }
        List<String> lines = Arrays.asList("package " + repositoryPackageName + ";", "", dsAnnoImport, "import com.tangzc.mpe.base.repository.BaseRepository;", "import " + entityPackageName + "." + entityName + ";", "import " + mapperPackageName + "." + mapperName + ";", "import org.springframework.stereotype.Repository;", "", dsAnno, "@Repository", "public class " + repositoryName + " extends BaseRepository<" + mapperName + ", " + entityName + "> {", "}");
        this.writeToFile(repositoryPackageName + "." + repositoryName, lines);
    }
}

