/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.core.ad.ad.splash;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.alimm.tanx.core.TanxCoreSdk;
import com.alimm.tanx.core.ad.ad.splash.AssetDownloadCallback;
import com.alimm.tanx.core.ad.bean.BidInfo;
import com.alimm.tanx.core.net.NetWorkManager;
import com.alimm.tanx.core.net.bean.DownLoadRequestBean;
import com.alimm.tanx.core.net.bean.RequestBean;
import com.alimm.tanx.core.net.okhttp.callback.OnDownloadListener;
import com.alimm.tanx.core.ut.UtErrorCode;
import com.alimm.tanx.core.ut.impl.TanxBaseUt;
import com.alimm.tanx.core.utils.FileUtils;
import com.alimm.tanx.core.utils.LogUtils;
import com.alimm.tanx.core.utils.MD5Utils;
import com.alimm.tanx.core.utils.Utils;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SplashAdCacheManager {
    private static final String TAG = "SplashAdCacheManager";
    private static final String SPLASH_AD_CACHE_PATH = "ad/splash";
    private static final String SPLASH_AD_RESPONSE_CACHE_PATH = "ad/splash_ad_resp";
    private static final String SPLASH_AD_ZIP_PATH = "zip";
    private static final String MAIN_PAGE = "index.html";
    private static final String PREF_LOCAL_ADV_IDS = "tanx_adsdk_local_adv_ids";
    private static final String PREF_KEY_PRE_REQUEST_ID = "pre_request_id";
    private static String sSplashAdCachePath = null;
    private static String sSplashAdZipCachePath = null;
    private static String sSplashAdResponseFile;
    private Context mContext = TanxCoreSdk.getApplication();
    private final int DEFAULT_EXPIRED_DAYS = 7;
    private final int DEFAULT_MAX_AD_COUNT = 15;

    private SplashAdCacheManager() {
    }

    public static SplashAdCacheManager getInstance() {
        return tanxc_do.tanxc_do;
    }

    public static String getSplashAdCacheDirPath(@NonNull Context context) {
        if (TextUtils.isEmpty((CharSequence)sSplashAdCachePath)) {
            File file = FileUtils.getExternalDir(context, 0);
            if (null != file) {
                sSplashAdCachePath = FileUtils.joinPath(file.getAbsolutePath(), SPLASH_AD_CACHE_PATH);
            } else {
                File file2 = FileUtils.getExternalDir(context, 1);
                if (null != file2) {
                    sSplashAdCachePath = FileUtils.joinPath(file2.getAbsolutePath(), SPLASH_AD_CACHE_PATH);
                }
            }
            LogUtils.d(TAG, "getSplashAdCacheDirPath: path = " + sSplashAdCachePath);
        }
        return sSplashAdCachePath;
    }

    public static String getSplashAdResponseFile(@NonNull Context context) {
        if (TextUtils.isEmpty((CharSequence)sSplashAdResponseFile)) {
            File file = FileUtils.getExternalDir(context, 0);
            if (null != file) {
                sSplashAdResponseFile = FileUtils.joinPath(file.getAbsolutePath(), SPLASH_AD_RESPONSE_CACHE_PATH);
            } else {
                File file2 = FileUtils.getExternalDir(context, 1);
                if (null != file2) {
                    sSplashAdResponseFile = FileUtils.joinPath(file2.getAbsolutePath(), SPLASH_AD_RESPONSE_CACHE_PATH);
                }
            }
            LogUtils.d(TAG, "getSplashAdResponseFile: fileName = " + sSplashAdResponseFile);
        }
        return sSplashAdResponseFile;
    }

    public static String getSplashAdZipCacheDirPath(@NonNull Context context) {
        if (TextUtils.isEmpty((CharSequence)sSplashAdZipCachePath)) {
            sSplashAdZipCachePath = FileUtils.joinPath(SplashAdCacheManager.getSplashAdCacheDirPath(context), SPLASH_AD_ZIP_PATH);
        }
        return sSplashAdZipCachePath;
    }

    public static String getSplashCacheFile(@NonNull Context context, String fileName) {
        String string;
        if (FileUtils.exists(SplashAdCacheManager.getSplashAdCacheDirPath(context)) && FileUtils.exists(string = FileUtils.joinPath(SplashAdCacheManager.getSplashAdCacheDirPath(context), fileName))) {
            return string;
        }
        return null;
    }

    private static void sortFilesByModifyTime(List<File> fileList) {
        if (fileList != null && fileList.size() > 1) {
            try {
                Collections.sort(fileList, new Comparator<File>(){

                    public int tanxc_do(File file, File file2) {
                        if (file == null && file2 == null) {
                            return 0;
                        }
                        if (file == null && file2 != null) {
                            return -1;
                        }
                        if (file != null && file2 == null) {
                            return 1;
                        }
                        if (file.lastModified() < file2.lastModified()) {
                            return -1;
                        }
                        if (file.lastModified() == file2.lastModified()) {
                            return 0;
                        }
                        return 1;
                    }

                    @Override
                    public /* synthetic */ int compare(Object object, Object object2) {
                        return this.tanxc_do((File)object, (File)object2);
                    }
                });
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LogUtils.d(TAG, "sortFilesByModifyTime: exception.", illegalArgumentException);
            }
        }
    }

    public void downloadAdAsset(List<BidInfo> bidInfoList, final AssetDownloadCallback assetDownloadCallback) {
        com.alimm.tanx.core.ad.ad.splash.tanxc_do.tanxc_do().tanxc_do(this.mContext);
        if (bidInfoList == null || bidInfoList.isEmpty()) {
            LogUtils.d(TAG, "downloadAdAsset no adv information.");
            return;
        }
        String string = SplashAdCacheManager.getSplashAdCacheDirPath(this.mContext);
        LogUtils.d(TAG, "downloadAdAsset cachePath=." + string);
        for (BidInfo bidInfo : bidInfoList) {
            if (bidInfo == null) continue;
            LogUtils.d(TAG, "\u4e0b\u8f7d\u7d20\u6750 downloadAdAsset: rs = " + bidInfo.getCreativePath() + ", name = " + bidInfo.getCreativeName() + ", RST = " + bidInfo.getCreativeType() + ", MD5 = " + bidInfo.getCreativeMd5());
            String string2 = bidInfo.getCreativePath();
            if (TextUtils.isEmpty((CharSequence)string2) || this.isAssetCached(bidInfo)) continue;
            RequestBean requestBean = new DownLoadRequestBean().setPath(string).setFileName(bidInfo.getCreativeName()).setTag(bidInfo.getCreativeName()).setUrl(string2);
            NetWorkManager.getInstance().sendHttpDownload(requestBean, new OnDownloadListener(){

                @Override
                public void onDownloadSuccess(File file) {
                    LogUtils.d("onDownloadSuccess" + file.getAbsolutePath(), new String[0]);
                    if (assetDownloadCallback != null) {
                        assetDownloadCallback.onSuccess(file);
                    }
                }

                @Override
                public void onDownLoadTotal(long total) {
                    LogUtils.d("onDownLoadTotal", total + "");
                }

                @Override
                public void onDownloading(int progress) {
                    LogUtils.d("onDownloading", progress + "");
                    if (progress == 50) {
                        // empty if block
                    }
                }

                @Override
                public void onDownloadFailed(int code, String msg) {
                    if (assetDownloadCallback != null) {
                        assetDownloadCallback.onFail(code, msg);
                    }
                    LogUtils.d("onDownloadFailed", "code:" + code + "  msg:" + msg);
                }
            });
        }
    }

    public void downloadAdAsset(final List<BidInfo> bidInfoList) {
        this.downloadAdAsset(bidInfoList, new AssetDownloadCallback(){

            @Override
            public void onSuccess(File file) {
                SplashAdCacheManager.this.handleAssetDownloadFinished(SplashAdCacheManager.this.mContext, bidInfoList);
            }

            @Override
            public void onFail(int code, String msg) {
            }
        });
    }

    private void handleAssetDownloadFinished(@NonNull Context context, @NonNull List<BidInfo> bidInfos) {
        HashMap<String, String> hashMap = new HashMap<String, String>(16);
        for (BidInfo bidInfo : bidInfos) {
            if (!this.isAssetCached(bidInfo)) continue;
            String string = Utils.formatTimeInMillis(bidInfo.getReleaseStartTime() * 1000L, "yyyy-MM-dd");
            String string2 = (String)hashMap.get(string);
            if (TextUtils.isEmpty((CharSequence)string2)) {
                hashMap.put(string, bidInfo.getCreativeId());
                continue;
            }
            hashMap.put(string, string2 + "," + bidInfo.getCreativeId());
        }
        this.setCacheAdvIds(hashMap);
    }

    public boolean isAssetCached(@NonNull BidInfo bidInfo) {
        return this.isAssetCached(bidInfo, false);
    }

    public boolean isAssetCached(@NonNull BidInfo bidInfo, boolean replaceAssetPath) {
        String string = SplashAdCacheManager.getSplashCacheFile(this.mContext, bidInfo.getCreativeName());
        LogUtils.d(TAG, "isAssetCached: filePath = " + string + ", replaceAssetPath = " + replaceAssetPath + ", creativeName = " + bidInfo.getCreativeName());
        return !TextUtils.isEmpty((CharSequence)string);
    }

    public void trimLocalCache() {
        this.deleteAssetForExpired(this.mContext, 7);
        this.deleteAssetForCacheFull(this.mContext, 15);
    }

    public void clearAllCachedAsset() {
        LogUtils.d(TAG, "clearAllCachedAsset.");
        FileUtils.delete(SplashAdCacheManager.getSplashAdCacheDirPath(this.mContext));
    }

    public void deleteAllCachedFiles() {
        LogUtils.d(TAG, "deleteAllCachedFiles.");
        this.deleteCachedResponseJson();
        this.clearAllCachedAsset();
        this.clearCachedAdvIds();
    }

    public void deleteCachedResponseJson() {
        LogUtils.d(TAG, "deleteCachedResponseJson.");
        FileUtils.delete(SplashAdCacheManager.getSplashAdResponseFile(this.mContext));
    }

    private void deleteAssetForCacheFull(@NonNull Context context, int maxCacheNum) {
        List<File> list = FileUtils.getFiles(SplashAdCacheManager.getSplashAdCacheDirPath(context));
        int n = list.size();
        LogUtils.d(TAG, "deleteAssetForCacheFull: maxCacheNum = " + maxCacheNum + ", fileCount = " + n);
        if (n >= maxCacheNum) {
            SplashAdCacheManager.sortFilesByModifyTime(list);
            int n2 = n - maxCacheNum / 2;
            LogUtils.d(TAG, "deleteAssetForCacheFull: deleteFileCount = " + n2);
            for (int i = 0; i < n2; ++i) {
                File file = list.get(i);
                com.alimm.tanx.core.ad.ad.splash.tanxc_do.tanxc_do().tanxc_do(context, file.getName(), 4);
                LogUtils.d(TAG, "deleteAssetForCacheFull: deleteFile = " + file.getName());
                FileUtils.deleteFile(file);
            }
        }
    }

    private void deleteAssetForExpired(final @NonNull Context context, int expireTime) {
        try {
            String string = SplashAdCacheManager.getSplashAdCacheDirPath(context);
            FileUtils.deleteExpiredFiles(string, expireTime, new FileUtils.FileKeepRule(){

                @Override
                public boolean needKept(String fileName) {
                    com.alimm.tanx.core.ad.ad.splash.tanxc_do.tanxc_do().tanxc_do(context, fileName, 3);
                    return false;
                }
            });
        }
        catch (Exception exception) {
            LogUtils.e(TAG, "deleteAssetForExpired: exception.", exception);
            TanxBaseUt.utError(UtErrorCode.CRASH_ERROR.getIntCode(), TAG, "deleteAssetForExpired: exception." + LogUtils.getStackTraceMessage(exception), "");
        }
    }

    public String getPreRequestId() {
        SharedPreferences sharedPreferences = this.mContext.getSharedPreferences(PREF_LOCAL_ADV_IDS, 0);
        String string = sharedPreferences.getString(PREF_KEY_PRE_REQUEST_ID, "");
        return string;
    }

    public void setPreRequestId(String preRequestId) {
        LogUtils.d(TAG, "setPreRequestId: preRequestId = " + preRequestId);
        SharedPreferences sharedPreferences = this.mContext.getSharedPreferences(PREF_LOCAL_ADV_IDS, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(PREF_KEY_PRE_REQUEST_ID, preRequestId);
        editor.apply();
    }

    public String getAdvIds(long currentTimeMills) {
        String string = Utils.formatTimeInMillis(currentTimeMills, "yyyy-MM-dd");
        SharedPreferences sharedPreferences = this.mContext.getSharedPreferences(PREF_LOCAL_ADV_IDS, 0);
        String string2 = sharedPreferences.getString(string, "");
        LogUtils.d(TAG, "getAdvIds: date = " + string + ", advIds = " + string2);
        return string2;
    }

    private void setCacheAdvIds(Map<String, String> cachedDateIdMap) {
        if (cachedDateIdMap == null || cachedDateIdMap.isEmpty()) {
            return;
        }
        SharedPreferences sharedPreferences = this.mContext.getSharedPreferences(PREF_LOCAL_ADV_IDS, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        for (Map.Entry<String, String> entry : cachedDateIdMap.entrySet()) {
            editor.putString(entry.getKey(), entry.getValue());
            LogUtils.d(TAG, "setCacheAdvIds: date = " + entry.getKey() + ", cached_ids = " + entry.getValue());
        }
        editor.apply();
    }

    public void clearCachedAdvIds() {
        LogUtils.d(TAG, "clearCachedAdvIds.");
        SharedPreferences sharedPreferences = this.mContext.getSharedPreferences(PREF_LOCAL_ADV_IDS, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.clear();
        editor.apply();
    }

    public boolean isFileMd5Matched(BidInfo bidInfo, String filePath) {
        if (bidInfo == null || TextUtils.isEmpty((CharSequence)bidInfo.getCreativeMd5()) || TextUtils.isEmpty((CharSequence)filePath)) {
            LogUtils.d(TAG, "isFileMd5Matched MD5\u6821\u9a8c\u662f\u5426\u901a\u8fc7:false ---bidInfo = " + bidInfo);
            if (bidInfo != null && TextUtils.isEmpty((CharSequence)bidInfo.getCreativeMd5())) {
                LogUtils.d(TAG, "isFileMd5Matched MD5\u6821\u9a8c\u662f\u5426\u901a\u8fc7:bidInfo.getCreativeMd5() \u4e3a\u7a7a");
            }
            if (TextUtils.isEmpty((CharSequence)filePath)) {
                LogUtils.d(TAG, "isFileMd5Matched MD5\u6821\u9a8c\u662f\u5426\u901a\u8fc7:\u672c\u5730\u7f13\u5b58\u6587\u4ef6\u540d\u79f0MD5 \u4e3a\u7a7a");
            }
            return false;
        }
        LogUtils.d(TAG, "isFileMd5Matched bidInfo.getCreativeMd5= " + bidInfo.getCreativeMd5() + " ---getFilePathMD5String= " + MD5Utils.getFilePathMD5String(filePath));
        return bidInfo.getCreativeMd5().equalsIgnoreCase(MD5Utils.getFilePathMD5String(filePath));
    }

    private static class tanxc_do {
        static final SplashAdCacheManager tanxc_do = new SplashAdCacheManager();
    }
}

