/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.core.ad.ad.splash.model;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alimm.tanx.core.TanxCoreSdk;
import com.alimm.tanx.core.ad.ad.splash.SplashAdCacheManager;
import com.alimm.tanx.core.ad.ad.splash.TanxSplashAd;
import com.alimm.tanx.core.ad.ad.splash.tanxc_do;
import com.alimm.tanx.core.ad.bean.AdInfo;
import com.alimm.tanx.core.ad.bean.BidInfo;
import com.alimm.tanx.core.ad.loader.ITanxRequestLoader;
import com.alimm.tanx.core.ad.model.BaseModel;
import com.alimm.tanx.core.common.AdTask;
import com.alimm.tanx.core.request.TanxAdSlot;
import com.alimm.tanx.core.request.TanxError;
import com.alimm.tanx.core.ut.UtErrorCode;
import com.alimm.tanx.core.ut.impl.TanxBaseUt;
import com.alimm.tanx.core.ut.impl.TanxSplashUt;
import com.alimm.tanx.core.utils.FileUtils;
import com.alimm.tanx.core.utils.LogUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SplashAdModel
extends BaseModel {
    private static final String TAG = "SplashAdModel";
    private static final String DEVICE_HEIGHT = "device_height";
    private static final int ERROR_NO_CACHE_LIST = -1000;
    private Context mContext = TanxCoreSdk.getApplication();
    private int mLoadDataCode;
    private String mRequestId = "";
    private boolean isSyncReq;
    private int fromType;

    public void sendRequest(boolean isSyncReq, TanxAdSlot adSlot, ITanxRequestLoader.ITanxRequestListener requestListener) {
        this.sendRequest(isSyncReq, adSlot, requestListener, 0L);
    }

    public void sendRequest(boolean isSyncReq, final TanxAdSlot adSlot, final ITanxRequestLoader.ITanxRequestListener requestListener, long timeOut) {
        this.adSlot = adSlot;
        this.isSyncReq = isSyncReq;
        this.requestListener = requestListener;
        if (!isSyncReq) {
            super.sendRequest(adSlot, requestListener, timeOut);
            LogUtils.d(TAG, "\u53d1\u8d77\u9884\u8bf7\u6c42 timeOut=" + timeOut);
        } else {
            this.startTimer(timeOut);
            com.alimm.tanx.core.common.tanxc_do.tanxc_do(new AdTask(new Runnable(){

                @Override
                public void run() {
                    long l = System.currentTimeMillis();
                    LogUtils.d(SplashAdModel.TAG, "\u5f00\u59cb\u83b7\u53d6\u672c\u5730\u7f13\u5b58\u6570\u636e ---" + l);
                    BidInfo bidInfo = SplashAdModel.this.chooseAd(false);
                    LogUtils.d(SplashAdModel.TAG, "\u83b7\u53d6\u672c\u5730\u7f13\u5b58\u6570\u636e\u7ed3\u675f --- bidInfo= " + bidInfo + "------" + (System.currentTimeMillis() - l) + "  hasTimeOut=" + SplashAdModel.this.hasTimeOut);
                    if (bidInfo == null) {
                        if (SplashAdModel.this.hasTimeOut) {
                            if (requestListener != null) {
                                requestListener.onError(new TanxError("timeout"));
                            }
                            return;
                        }
                        SplashAdModel.this.fromType = 1;
                        LogUtils.d(SplashAdModel.TAG, "\u83b7\u53d6\u672c\u5730\u7f13\u5b58\u65e0\u7f13\u5b58 \u5f00\u59cb\u8d70\u5b9e\u65f6\u8bf7\u6c42\u903b\u8f91---------" + System.currentTimeMillis());
                        SplashAdModel.super.sendRequest(adSlot, requestListener, 0L);
                    }
                }
            }, "sendRequest", new AdTask.onErrorListener(){

                @Override
                public void onError(String msg) {
                    requestListener.onError(new TanxError(msg));
                }
            }));
        }
    }

    @Override
    protected String getScene() {
        return "screen";
    }

    @Override
    protected void onSuccess(AdInfo adInfo) {
        this.handleRequestResponse(adInfo);
    }

    private BidInfo chooseAd(boolean isColdStart) {
        TanxSplashAd tanxSplashAd;
        AdInfo adInfo = this.getAdInfoFromCache();
        LogUtils.d(TAG, "chooseAd: cold = " + isColdStart + ", hasAdInfo = " + (adInfo != null));
        if (adInfo == null || adInfo.getAdCount() <= 0) {
            this.mLoadDataCode = UtErrorCode.ERROR_NO_AD_ITEM.getIntCode();
            LogUtils.e("chooseAd", "\u9884\u8bf7\u6c42\u65e0\u5e7f\u544a\u8282\u70b9");
            return null;
        }
        this.mRequestId = adInfo.getRequestId();
        boolean bl = false;
        for (BidInfo bidInfo : adInfo.getBidInfoList()) {
            tanxSplashAd = new TanxSplashAd(this.adSlot, bidInfo, adInfo.getRequestId(), 0, this.getScene());
            if (this.isDuringRelease(bidInfo)) {
                bl = true;
                TanxSplashUt.utSplashJsonCheck(tanxSplashAd, 0, true, 0);
                if (!this.isAssetExists(bidInfo)) continue;
                LogUtils.d(TAG, "chooseAd: isAssetExists bidInfo = " + bidInfo);
                if (!this.hasTimeOut) {
                    this.cancel();
                    TanxSplashUt.utSplashTimer(tanxSplashAd, 0, true, 0);
                    if (this.requestListener != null) {
                        this.requestListener.onSuccess(Arrays.asList(tanxSplashAd));
                    }
                    TanxSplashUt.utSplashCacheExist(tanxSplashAd, 0, true, 0);
                } else {
                    this.mLoadDataCode = UtErrorCode.ERROR_AD_TIME_OUT.getIntCode();
                    TanxSplashUt.utSplashCacheExist(tanxSplashAd, 0, false, this.mLoadDataCode);
                }
                return bidInfo;
            }
            LogUtils.d(TAG, "chooseAd: \u4e0d\u5728\u6295\u653e\u671f bidInfo = " + bidInfo);
            this.mLoadDataCode = UtErrorCode.ERROR_AD_NOT_IN_DURING_RELEASE.getIntCode();
            TanxSplashUt.utSplashJsonCheck(tanxSplashAd, 0, false, this.mLoadDataCode);
        }
        this.mLoadDataCode = bl ? UtErrorCode.ERROR_NO_CACHED_ASSET.getIntCode() : UtErrorCode.ERROR_NO_AD_DURING_RELEASE.getIntCode();
        tanxSplashAd = new TanxSplashAd(this.adSlot, null, adInfo.getRequestId(), 0, this.getScene());
        TanxSplashUt.utSplashCacheExist(tanxSplashAd, 0, false, this.mLoadDataCode);
        return null;
    }

    private boolean isAssetExists(@NonNull BidInfo bidInfo) {
        return SplashAdCacheManager.getInstance().isAssetCached(bidInfo, true);
    }

    private boolean isDuringRelease(@NonNull BidInfo bidInfo) {
        long l = System.currentTimeMillis() / 1000L;
        return bidInfo.getReleaseStartTime() <= l && bidInfo.getReleaseEndTime() >= l;
    }

    private AdInfo getAdInfoFromCache() {
        long l = System.currentTimeMillis();
        AdInfo adInfo = null;
        boolean bl = false;
        try {
            String string = SplashAdCacheManager.getSplashAdResponseFile(this.mContext);
            String string2 = FileUtils.getStrFromFile(string);
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                bl = true;
                adInfo = (AdInfo)JSON.parseObject((String)string2, AdInfo.class, (Feature[])new Feature[]{Feature.IgnoreNotMatch});
                adInfo = com.alimm.tanx.core.request.tanxc_do.tanxc_do(adInfo);
            }
        }
        catch (Exception exception) {
            LogUtils.e(TAG, "getAdInfoFromCache exception.", exception);
            TanxBaseUt.utError(UtErrorCode.CRASH_ERROR.getIntCode(), TAG, "getAdInfoFromCache exception." + LogUtils.getStackTraceMessage(exception), "");
        }
        LogUtils.d(TAG, "getAdInfoFromCache: time = " + (System.currentTimeMillis() - l) + ",hasContent = " + bl + ", count = " + (adInfo != null ? adInfo.getAdCount() : 0));
        return adInfo;
    }

    private void cacheAdInfo(String adResponse) {
        try {
            if (!TextUtils.isEmpty((CharSequence)adResponse)) {
                String string = SplashAdCacheManager.getSplashAdResponseFile(this.mContext);
                LogUtils.d(TAG, "cacheAdInfo fileName= " + string);
                FileUtils.saveStr2File(string, adResponse);
            }
        }
        catch (Exception exception) {
            LogUtils.e(TAG, "cacheAdInfo error", exception);
            TanxBaseUt.utError(UtErrorCode.CRASH_ERROR.getIntCode(), TAG, "cacheAdInfo error" + LogUtils.getStackTraceMessage(exception), "");
        }
    }

    private void deleteCachedAdInBackground() {
        com.alimm.tanx.core.common.tanxc_do.tanxc_do(new AdTask(new Runnable(){

            @Override
            public void run() {
                SplashAdCacheManager.getInstance().deleteCachedResponseJson();
            }
        }, "deleteCachedAdInBackground"));
    }

    private void handleRequestResponse(AdInfo adInfo) {
        LogUtils.d(TAG, "handleRequestCallback: adInfo = " + adInfo + "");
        if (this.isSyncReq && !this.hasTimeOut) {
            if (adInfo == null || adInfo.getSeatList() == null || adInfo.getSeatList().size() <= 0 || adInfo.getSeatList().get(0) == null || adInfo.getSeatList().get(0).getBidList() == null || adInfo.getSeatList().get(0).getBidList().size() <= 0) {
                this.requestListener.onError(new TanxError(adInfo.getRequestId(), "adInfo adCount is null"));
            } else {
                ArrayList<TanxSplashAd> arrayList = new ArrayList<TanxSplashAd>();
                for (int i = 0; i < adInfo.getSeatList().size(); ++i) {
                    List<BidInfo> list = adInfo.getSeatList().get(i).getBidList();
                    if (list == null || list.size() <= 0) continue;
                    for (BidInfo bidInfo : list) {
                        LogUtils.d(TAG, "handleRequestCallback: bidInfo = " + bidInfo + "");
                        if (bidInfo != null) {
                            LogUtils.d(TAG, "handleRequestCallback: \u7d20\u6750\u5730\u5740 = " + bidInfo.getCreativePath() + "");
                        }
                        arrayList.add(new TanxSplashAd(this.adSlot, bidInfo, adInfo.getRequestId(), 1, this.getScene()));
                    }
                }
                this.requestListener.onSuccess(arrayList);
            }
        }
        this.cacheAndManageAsset(adInfo);
    }

    private void cacheAndManageAsset(final AdInfo adInfo) {
        if (adInfo == null) {
            return;
        }
        com.alimm.tanx.core.common.tanxc_do.tanxc_do(new AdTask(new Runnable(){

            @Override
            public void run() {
                if (!SplashAdModel.this.isSyncReq) {
                    SplashAdModel.this.cacheAdInfo(JSON.toJSONString((Object)adInfo));
                    SplashAdCacheManager.getInstance().clearCachedAdvIds();
                    if (adInfo != null) {
                        SplashAdCacheManager.getInstance().setPreRequestId(adInfo.getRequestId());
                    }
                }
                tanxc_do.tanxc_do().tanxc_do(SplashAdModel.this.mContext);
                if (adInfo != null && adInfo.getBidInfoList() != null && adInfo.getBidInfoList().size() > 0) {
                    for (BidInfo bidInfo : adInfo.getBidInfoList()) {
                        tanxc_do.tanxc_do().tanxc_do(SplashAdModel.this.mContext, bidInfo.getCreativeName(), 0);
                    }
                }
                SplashAdCacheManager.getInstance().trimLocalCache();
                SplashAdCacheManager.getInstance().downloadAdAsset(adInfo.getBidInfoList());
            }
        }, "handleRequestResponse"));
    }

    @Override
    protected void timerCancelNotify(AdInfo adInfo, boolean isSucceed, int code) {
        TanxSplashAd tanxSplashAd = null;
        if (adInfo != null) {
            BidInfo bidInfo = null;
            if (adInfo.getBidInfoList() != null && adInfo.getBidInfoList().size() > 0) {
                bidInfo = adInfo.getBidInfoList().get(0);
            }
            tanxSplashAd = new TanxSplashAd(this.adSlot, bidInfo, adInfo.getRequestId(), 0, this.getScene());
        }
        TanxSplashUt.utSplashTimer(tanxSplashAd, this.fromType, isSucceed, code);
    }

    @Override
    public void requestSucc(AdInfo adInfo) {
        if (!this.isCancel) {
            this.checkSuccess(adInfo);
            this.cancel();
            this.timerCancelNotify(adInfo, true, 0);
        }
    }
}

