/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.core.ad.browser;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.http.SslError;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.DownloadListener;
import android.webkit.SslErrorHandler;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import com.alimm.tanx.core.ad.bean.BidInfo;
import com.alimm.tanx.core.ad.browser.IAdWebViewCallback;
import com.alimm.tanx.core.ad.tanxc_do.tanxc_int;
import com.alimm.tanx.core.ut.UtErrorCode;
import com.alimm.tanx.core.ut.impl.TanxBaseUt;
import com.alimm.tanx.core.utils.LandingPageUtHelper;
import com.alimm.tanx.core.utils.LogUtils;

public class TanxBrowserContainer
extends FrameLayout
implements DownloadListener {
    protected Context tanxc_do;
    protected WebView tanxc_if;
    protected String tanxc_for;
    protected BidInfo tanxc_int;
    protected ViewGroup tanxc_new;
    protected long tanxc_try;
    protected boolean tanxc_byte = false;
    private ProgressBar tanxc_case;
    private boolean tanxc_char = false;
    private boolean tanxc_else = false;
    private IAdWebViewCallback tanxc_goto;
    private LandingPageUtHelper tanxc_long;

    public TanxBrowserContainer(Context context) {
        this(context, null);
    }

    public TanxBrowserContainer(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TanxBrowserContainer(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.tanxc_do = context;
        LogUtils.d("AdSystemWebViewContainer", "AdClickWebViewContainer: mContext = " + this.tanxc_do);
        this.tanxc_do(this.tanxc_do);
    }

    @TargetApi(value=21)
    public TanxBrowserContainer(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.tanxc_do = context;
        LogUtils.d("AdSystemWebViewContainer", "AdClickWebViewContainer: mContext = " + this.tanxc_do);
        this.tanxc_do(this.tanxc_do);
    }

    public boolean tanxc_do(String string, LandingPageUtHelper landingPageUtHelper, boolean bl) {
        if (TextUtils.isEmpty((CharSequence)string) || this.tanxc_if == null) {
            LogUtils.d("AdSystemWebViewContainer", "loadUrl: skip because url is empty.");
            return false;
        }
        this.tanxc_try = System.currentTimeMillis();
        this.tanxc_long = landingPageUtHelper;
        this.tanxc_long.setLoadUrlTime(this.tanxc_try);
        this.tanxc_for = string;
        this.tanxc_if.loadUrl(string);
        return true;
    }

    public boolean tanxc_do() {
        return this.tanxc_byte;
    }

    public String tanxc_if() {
        if (this.tanxc_if != null) {
            return this.tanxc_if.getUrl();
        }
        return "";
    }

    public void tanxc_for() {
        if (this.tanxc_if != null) {
            this.tanxc_if.reload();
        }
    }

    public void tanxc_int() {
        if (this.tanxc_if != null) {
            this.tanxc_if.onPause();
        }
    }

    public void tanxc_new() {
        if (this.tanxc_if != null) {
            this.tanxc_if.onResume();
        }
    }

    public void tanxc_try() {
        if (this.tanxc_if != null) {
            this.tanxc_if.setVisibility(8);
            this.tanxc_if.removeAllViews();
            this.tanxc_if = null;
        }
    }

    public boolean tanxc_byte() {
        if (this.tanxc_new != null && this.tanxc_new.getChildCount() > 0) {
            this.tanxc_char();
            return true;
        }
        if (this.tanxc_if != null && this.tanxc_if.canGoBack()) {
            this.tanxc_if.goBack();
            return true;
        }
        return false;
    }

    public void tanxc_do(BidInfo bidInfo) {
        LogUtils.d("AdSystemWebViewContainer", "setBidInfo: bidInfo = " + bidInfo);
        this.tanxc_int = bidInfo;
    }

    public void tanxc_do(ProgressBar progressBar) {
        this.tanxc_case = progressBar;
    }

    public void tanxc_do(IAdWebViewCallback iAdWebViewCallback) {
        this.tanxc_goto = iAdWebViewCallback;
    }

    private void tanxc_do(Context context) {
        try {
            this.tanxc_if = new WebView(context);
            this.tanxc_if.setBackgroundColor(0);
        }
        catch (Throwable throwable) {
            LogUtils.e("AdSystemWebViewContainer", "Create new Webview exception.", throwable);
            TanxBaseUt.utError(UtErrorCode.CRASH_ERROR.getIntCode(), "AdSystemWebViewContainer", "Create new Webview exception." + LogUtils.getStackTraceMessage(throwable), "");
            this.tanxc_if = null;
            return;
        }
        this.tanxc_byte = true;
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        this.addView((View)this.tanxc_if, (ViewGroup.LayoutParams)layoutParams);
        this.tanxc_new = new FrameLayout(context);
        this.tanxc_new.setVisibility(8);
        this.addView((View)this.tanxc_new, -1, -1);
        this.tanxc_case();
    }

    private void tanxc_case() {
        WebSettings webSettings = this.tanxc_if.getSettings();
        try {
            webSettings.setJavaScriptEnabled(true);
        }
        catch (Exception exception) {
            LogUtils.e("AdSystemWebViewContainer", "initWebView: failed with exception.", exception);
            TanxBaseUt.utError(UtErrorCode.CRASH_ERROR.getIntCode(), "AdSystemWebViewContainer", "initWebView: failed with exception." + LogUtils.getStackTraceMessage(exception), "");
        }
        String string = webSettings.getUserAgentString();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            webSettings.setUserAgentString(string);
        }
        LogUtils.d("AdSystemWebViewContainer", "initWebSettings: userAgent = " + webSettings.getUserAgentString());
        webSettings.setUseWideViewPort(true);
        webSettings.setLoadWithOverviewMode(true);
        webSettings.setSupportZoom(true);
        webSettings.setBuiltInZoomControls(true);
        webSettings.setDomStorageEnabled(true);
        if (Build.VERSION.SDK_INT < 18) {
            webSettings.setSavePassword(false);
        }
        webSettings.setDatabaseEnabled(false);
        webSettings.setNeedInitialFocus(true);
        if (Build.VERSION.SDK_INT >= 21) {
            webSettings.setMixedContentMode(0);
        }
        this.tanxc_if.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                boolean bl = view.getHitTestResult() != null && com.alimm.tanx.core.ad.tanxc_do.tanxc_int.tanxc_do(view.getHitTestResult().getType(), TanxBrowserContainer.this.tanxc_try);
                boolean bl2 = com.alimm.tanx.core.ad.tanxc_do.tanxc_int.tanxc_do(view.getContext(), url, TanxBrowserContainer.this.tanxc_int);
                boolean bl3 = bl2 || super.shouldOverrideUrlLoading(view, url);
                return bl3;
            }

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                super.onPageStarted(view, url, favicon);
                LogUtils.d("AdSystemWebViewContainer", "onPageStarted: url = " + url);
                if (TanxBrowserContainer.this.tanxc_case != null) {
                    TanxBrowserContainer.this.tanxc_case.setVisibility(0);
                }
            }

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                LogUtils.d("AdSystemWebViewContainer", "onPageFinished: time = " + (System.currentTimeMillis() - TanxBrowserContainer.this.tanxc_try) + "; url = " + url);
                if (TanxBrowserContainer.this.tanxc_case != null) {
                    TanxBrowserContainer.this.tanxc_case.setVisibility(8);
                }
            }

            @TargetApi(value=21)
            public void onReceivedHttpError(WebView view, WebResourceRequest request, WebResourceResponse errorResponse) {
                super.onReceivedHttpError(view, request, errorResponse);
                if (request.isForMainFrame()) {
                    LogUtils.d("AdSystemWebViewContainer", "onReceivedHttpError: code = " + errorResponse.getStatusCode());
                    TanxBrowserContainer.this.tanxc_do(errorResponse.getStatusCode(), "");
                }
            }

            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                super.onReceivedError(view, errorCode, description, failingUrl);
                LogUtils.d("AdSystemWebViewContainer", "onReceivedError: errorCode = " + errorCode + ", url = " + failingUrl + ", description = " + description);
                TanxBrowserContainer.this.tanxc_do(errorCode, description);
            }

            public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
                LogUtils.d("AdSystemWebViewContainer", "onReceivedSslError: handler = " + handler + ", error = " + error);
                handler.proceed();
            }

            public WebResourceResponse shouldInterceptRequest(WebView view, String url) {
                return super.shouldInterceptRequest(view, url);
            }
        });
        this.tanxc_if.setWebChromeClient(new WebChromeClient(){

            public void onReceivedTitle(WebView view, String title) {
                TanxBrowserContainer.this.tanxc_goto.onTitleLoaded(title);
            }

            public void onShowCustomView(View view, WebChromeClient.CustomViewCallback callback) {
                TanxBrowserContainer.this.tanxc_do(view, callback);
            }

            public void onHideCustomView() {
                TanxBrowserContainer.this.tanxc_char();
            }

            public void onProgressChanged(WebView view, int newProgress) {
                super.onProgressChanged(view, newProgress);
                LogUtils.d("AdSystemWebViewContainer", "onProgressChanged: newProgress = " + newProgress);
                if (TanxBrowserContainer.this.tanxc_case != null) {
                    TanxBrowserContainer.this.tanxc_case.setProgress(newProgress);
                    if (newProgress == 100) {
                        TanxBrowserContainer.this.tanxc_case.setVisibility(8);
                    }
                }
            }
        });
        this.tanxc_if.setDownloadListener((DownloadListener)this);
    }

    public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimeType, long contentLength) {
        LogUtils.d("AdSystemWebViewContainer", "onDownloadStart: url = " + url + ", mimeType = " + mimeType + ", contentLength = " + contentLength);
    }

    private void tanxc_do(int n, String string) {
        if (this.tanxc_case != null) {
            this.tanxc_case.setVisibility(8);
        }
        if (!this.tanxc_char && this.tanxc_long != null) {
            this.tanxc_long.setLoadFinishTime(System.currentTimeMillis(), -1);
            this.tanxc_long.recordLandingFinish(this.tanxc_int, "2");
            this.tanxc_char = true;
        }
    }

    private void tanxc_do(View view, WebChromeClient.CustomViewCallback customViewCallback) {
        LogUtils.d("AdSystemWebViewContainer", "showCustomView: view = " + view + ", callback = " + customViewCallback + ", mPlayerContainer = " + this.tanxc_new);
        if (this.tanxc_if != null) {
            this.tanxc_if.setVisibility(8);
        }
        if (this.tanxc_new != null) {
            if (view != null && view.getParent() != null) {
                ((ViewGroup)view.getParent()).removeView(view);
            }
            this.tanxc_new.setVisibility(0);
            this.tanxc_new.addView(view);
        }
        if (this.tanxc_goto != null) {
            this.tanxc_goto.onShowCustomView(view);
        }
    }

    private void tanxc_char() {
        LogUtils.d("AdSystemWebViewContainer", "showCustomView: mDefaultWebView = " + this.tanxc_if + ", mPlayerContainer = " + this.tanxc_new);
        if (null != this.tanxc_if) {
            this.tanxc_if.setVisibility(0);
        }
        if (this.tanxc_new != null) {
            this.tanxc_new.removeAllViews();
            this.tanxc_new.setVisibility(8);
        }
        if (this.tanxc_goto != null) {
            this.tanxc_goto.onHideCustomView();
        }
    }
}

