/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.core.ad.event.track.interaction;

import android.text.TextUtils;
import com.alimm.tanx.core.ad.bean.TrackItem;
import com.alimm.tanx.core.net.NetWorkManager;
import com.alimm.tanx.core.net.bean.RequestBean;
import com.alimm.tanx.core.net.callback.NetWorkCallBack;
import com.alimm.tanx.core.utils.LogUtils;
import java.util.List;

public class InteractionUpload {
    private static final String TAG = "InteractionUpload";
    private static InteractionUpload instance;
    private static final String INTERACT_TYPE = "__INTERACT_TYPE__";
    private static final String INTERACT_DESC = "__INTERACT_DESC__";
    public static final int CLOSE = 3;
    public static final int UNINTERESTED = 4;
    public static final int POOR_CONTENT = 5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InteractionUpload getInstance() {
        if (null != instance) return instance;
        Class<InteractionUpload> clazz = InteractionUpload.class;
        synchronized (InteractionUpload.class) {
            if (instance != null) return instance;
            instance = new InteractionUpload();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void uploadInteraction(List<TrackItem> trackItems, int nowInteractType) {
        this.uploadInteraction(trackItems, nowInteractType, "");
    }

    public void uploadInteraction(List<TrackItem> trackItems, int nowInteractType, String desc) {
        this.uploadInteraction(trackItems, nowInteractType + "", desc);
    }

    public void uploadInteraction(List<TrackItem> trackItems, String nowInteractType, String desc) {
        if (trackItems != null) {
            for (TrackItem trackItem : trackItems) {
                int n;
                if (trackItem == null || (n = trackItem.getType()) != 5) continue;
                List<String> list = trackItem.getUrl();
                for (String string : list) {
                    if (TextUtils.isEmpty((CharSequence)string)) continue;
                    try {
                        string = TextUtils.isEmpty((CharSequence)nowInteractType) ? string.replace(INTERACT_TYPE, "") : string.replace(INTERACT_TYPE, nowInteractType);
                        string = TextUtils.isEmpty((CharSequence)desc) ? string.replace(INTERACT_DESC, "") : string.replace(INTERACT_DESC, desc);
                    }
                    catch (Exception exception) {
                        LogUtils.e("uploadInteraction", exception);
                    }
                    RequestBean requestBean = new RequestBean().setUrl(string).build();
                    requestBean.setOverrideError(true);
                    NetWorkManager.getInstance().sendHttpGet(requestBean, Object.class, false, false, new NetWorkCallBack(){

                        @Override
                        public void error(int code, String error) {
                            LogUtils.d(InteractionUpload.TAG, error);
                        }

                        public void succ(Object o) {
                            LogUtils.d(InteractionUpload.TAG, "");
                        }
                    });
                }
            }
        }
    }
}

