/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.core.ad.model;

import android.os.Handler;
import android.os.Looper;
import com.alimm.tanx.core.ad.bean.AdInfo;
import com.alimm.tanx.core.ad.bean.BidInfo;
import com.alimm.tanx.core.ad.loader.ITanxRequestLoader;
import com.alimm.tanx.core.ad.model.IModel;
import com.alimm.tanx.core.net.callback.NetWorkCallBack;
import com.alimm.tanx.core.request.AdRequest;
import com.alimm.tanx.core.request.TanxAdSlot;
import com.alimm.tanx.core.request.TanxError;
import com.alimm.tanx.core.ut.UtErrorCode;
import com.alimm.tanx.core.utils.LogUtils;

public abstract class BaseModel
implements IModel,
Runnable {
    private final String TAG = "BaseModel";
    protected TanxAdSlot adSlot;
    protected BidInfo bidInfo;
    protected ITanxRequestLoader.ITanxRequestListener requestListener;
    protected Handler handler = new Handler(Looper.getMainLooper());
    protected boolean hasTimeOut;
    protected boolean hasRequest;
    protected boolean isCancel;

    @Override
    public void sendRequest(TanxAdSlot adSlot, ITanxRequestLoader.ITanxRequestListener requestListener) {
        this.sendRequest(adSlot, requestListener, 0L);
    }

    @Override
    public void sendRequest(TanxAdSlot adSlot, final ITanxRequestLoader.ITanxRequestListener requestListener, long timeOut) {
        this.adSlot = adSlot;
        this.requestListener = requestListener;
        LogUtils.d("BaseModel", "\u53d1\u8d77\u8bf7\u6c42 hasRequest=" + this.hasRequest);
        if (this.hasRequest) {
            throw new IllegalStateException("has request");
        }
        this.hasRequest = true;
        this.startTimer(timeOut);
        AdRequest.request(adSlot, this.getScene(), new NetWorkCallBack<AdInfo>(){

            @Override
            public void error(int code, String error) {
                LogUtils.e("BaseModel", "\u53d1\u8d77\u8bf7\u6c42 error=" + error);
                if (!BaseModel.this.isCancel && !BaseModel.this.hasTimeOut) {
                    if (requestListener != null) {
                        requestListener.onError(new TanxError(error));
                    }
                    BaseModel.this.cancel();
                    BaseModel.this.timerCancelNotify(null, true, 0);
                }
            }

            public void tanxc_do(AdInfo adInfo) {
                LogUtils.d("BaseModel", "\u53d1\u8d77\u8bf7\u6c42 isCancel=" + BaseModel.this.isCancel + "--- hasTimeOut= " + BaseModel.this.hasTimeOut);
                BaseModel.this.requestSucc(adInfo);
            }

            @Override
            public /* synthetic */ void succ(Object object) {
                this.tanxc_do((AdInfo)object);
            }
        });
    }

    public void requestSucc(AdInfo adInfo) {
        if (!this.isCancel && !this.hasTimeOut) {
            this.checkSuccess(adInfo);
            this.cancel();
            this.timerCancelNotify(adInfo, true, 0);
        }
    }

    public void startTimer(long timeOut) {
        LogUtils.d("BaseModel", "\u542f\u52a8\u8ba1\u65f6\u5668 timeOut=" + timeOut);
        if (timeOut > 0L) {
            this.handler.postDelayed((Runnable)this, timeOut);
        }
    }

    @Override
    public void cancel() {
        this.isCancel = true;
        if (this.handler != null) {
            this.handler.removeCallbacks((Runnable)this);
        }
        LogUtils.d("BaseModel", "\u8ba1\u65f6\u5668\u53d6\u6d88");
    }

    @Override
    public void run() {
        this.hasTimeOut = true;
        if (this.requestListener != null) {
            this.requestListener.onTimeOut();
            LogUtils.d("BaseModel", "\u8ba1\u65f6\u5668\u8fbe\u5230\u8d85\u65f6");
        }
        this.timerCancelNotify(null, false, UtErrorCode.TIMER_OUT.getIntCode());
    }

    public void checkSuccess(AdInfo adInfo) {
        if (adInfo == null) {
            if (this.requestListener != null) {
                this.requestListener.onError(new TanxError("adInfo is null"));
            }
            return;
        }
        this.onSuccess(adInfo);
    }

    protected abstract String getScene();

    protected abstract void onSuccess(AdInfo var1);

    protected abstract void timerCancelNotify(AdInfo var1, boolean var2, int var3);
}

