/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.core.ad.view;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.alimm.tanx.core.R;
import com.alimm.tanx.core.ad.view.ActionMenu;
import java.util.List;

public class WebMenuDialog
extends Dialog {
    private Context mContext;
    private List<ActionMenu> mMenuList;
    private LayoutInflater mInflater;
    private MenuClick mMenuClick;
    private AdapterView.OnItemClickListener onMenuOnItemClickListener = new AdapterView.OnItemClickListener(){

        public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
            ActionMenu actionMenu = (ActionMenu)((Object)WebMenuDialog.this.mMenuList.get(position));
            WebMenuDialog.this.mMenuClick.click(actionMenu.id);
            WebMenuDialog.this.dismiss();
        }
    };

    public WebMenuDialog(Context context, List<ActionMenu> mMenuList, MenuClick menuClick) {
        super(context, R.style.Theme_Tanx_Browser_Dialog);
        this.mContext = context;
        this.mMenuClick = menuClick;
        this.mMenuList = mMenuList;
        this.mInflater = LayoutInflater.from((Context)context);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setCanceledOnTouchOutside(true);
        if (this.getWindow() != null) {
            this.getWindow().setGravity(53);
            this.getWindow().getAttributes().y = this.mContext.getResources().getDimensionPixelOffset(R.dimen.tanx_browser_default_height);
            this.getWindow().getAttributes().width = -2;
            this.getWindow().getAttributes().height = -2;
        }
        this.setContentView(R.layout.tanx_layout_browser_popmenu);
        ListView listView = (ListView)this.findViewById(R.id.tanx_browser_menu_listview);
        MenuAdapter menuAdapter = new MenuAdapter();
        listView.setAdapter((ListAdapter)menuAdapter);
        listView.setOnItemClickListener(this.onMenuOnItemClickListener);
    }

    class MenuAdapter
    extends BaseAdapter {
        MenuAdapter() {
        }

        public int getCount() {
            return WebMenuDialog.this.mMenuList.size();
        }

        public Object getItem(int position) {
            return WebMenuDialog.this.mMenuList.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            ViewHolder viewHolder;
            if (convertView == null) {
                viewHolder = new ViewHolder();
                convertView = WebMenuDialog.this.mInflater.inflate(R.layout.tanx_layout_browser_simple_popmenu_items, parent, false);
                viewHolder.img = (ImageView)convertView.findViewById(R.id.tanx_browser_menu_item_img);
                viewHolder.txt = (TextView)convertView.findViewById(R.id.tanx_browser_menu_item_title);
                convertView.setTag((Object)viewHolder);
            } else {
                viewHolder = (ViewHolder)convertView.getTag();
            }
            ActionMenu actionMenu = (ActionMenu)((Object)this.getItem(position));
            viewHolder.img.setImageResource(actionMenu.drawable);
            viewHolder.txt.setText((CharSequence)actionMenu.name);
            return convertView;
        }
    }

    static class ViewHolder {
        ImageView img;
        TextView txt;

        ViewHolder() {
        }
    }

    public static interface MenuClick {
        public void click(int var1);
    }
}

