/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.core.orange;

import android.text.TextUtils;
import com.alibaba.fastjson.JSON;
import com.alimm.tanx.core.TanxCoreSdk;
import com.alimm.tanx.core.net.NetWorkManager;
import com.alimm.tanx.core.net.bean.RequestBean;
import com.alimm.tanx.core.net.callback.NetWorkCallBack;
import com.alimm.tanx.core.orange.OrangeInitListener;
import com.alimm.tanx.core.orange.bean.OrangeBean;
import com.alimm.tanx.core.request.C;
import com.alimm.tanx.core.ut.UtErrorCode;
import com.alimm.tanx.core.ut.impl.TanxBaseUt;
import com.alimm.tanx.core.utils.LogUtils;
import com.alimm.tanx.core.utils.SharedPreferencesHelper;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;

public class OrangeManager {
    private static final String TAG = "OrangeManager";
    private volatile OrangeBean orangeBean;
    private static volatile OrangeManager instance;
    private OrangeInitListener orangeInitListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OrangeManager getInstance() {
        if (instance != null) return instance;
        Class<OrangeManager> clazz = OrangeManager.class;
        synchronized (OrangeManager.class) {
            if (instance != null) return instance;
            instance = new OrangeManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void init() {
        this.init(null);
    }

    public void init(OrangeInitListener orangeInitListener) {
        this.orangeInitListener = orangeInitListener;
        this.readLocalOrange();
        this.request();
    }

    private void request() {
        RequestBean requestBean = new RequestBean().setUrl(C.getOrangeUrl()).build();
        requestBean.setOverrideError(true);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Content-Type", "application/json; charset=utf-8");
        requestBean.setHeads(hashMap);
        NetWorkManager.getInstance().sendHttpGet(requestBean, OrangeBean.class, (NetWorkCallBack)new NetWorkCallBack<OrangeBean>(){

            @Override
            public void error(int code, String error) {
                LogUtils.e(OrangeManager.TAG, "orange\u914d\u7f6e\u62c9\u53d6\u5931\u8d25-> code:" + code + "  error->" + error);
                OrangeManager.this.callBack();
                TanxBaseUt.utError(code, OrangeManager.TAG, "orange\u914d\u7f6e\u62c9\u53d6\u5931\u8d25-> code:" + code + "  error->" + error, "");
            }

            public void tanxc_do(OrangeBean orangeBean) {
                OrangeManager.this.checkOrangeVersion2Write(orangeBean);
                LogUtils.d(OrangeManager.TAG, "Orange\u670d\u52a1\u5668\u7248\u672c\u4e3a->" + orangeBean.version);
            }

            @Override
            public /* synthetic */ void succ(Object object) {
                this.tanxc_do((OrangeBean)object);
            }
        });
    }

    private void checkAndCreateDefaultOrange() {
        try {
            String string;
            if (this.orangeBean == null && !TextUtils.isEmpty((CharSequence)(string = this.getFromAssets("orange.json")))) {
                this.orangeBean = (OrangeBean)JSON.parseObject((String)string, OrangeBean.class);
                LogUtils.d(TAG, "\u672c\u5730\u521d\u59cborange\u914d\u7f6e->" + string);
            }
        }
        catch (Exception exception) {
            LogUtils.e(TAG, exception);
            TanxBaseUt.utError(UtErrorCode.CRASH_ERROR.getIntCode(), TAG, LogUtils.getStackTraceMessage(exception), "");
        }
    }

    private void checkOrangeVersion2Write(OrangeBean netOrangeBean) {
        if (netOrangeBean != null && (this.orangeBean == null || this.orangeBean.version < netOrangeBean.version)) {
            this.writeOrange(netOrangeBean);
            this.orangeBean = netOrangeBean;
        }
        this.callBack();
    }

    private void readLocalOrange() {
        try {
            SharedPreferencesHelper sharedPreferencesHelper = SharedPreferencesHelper.getInstance();
            SharedPreferencesHelper.getInstance();
            String string = sharedPreferencesHelper.getString("KEY_ORANGE");
            if (!TextUtils.isEmpty((CharSequence)string)) {
                this.orangeBean = (OrangeBean)JSON.parseObject((String)string, OrangeBean.class);
                LogUtils.d(TAG, "Orange\u672c\u5730\u7248\u672c\u4e3a->" + this.orangeBean.version);
                LogUtils.d(TAG, "\u672c\u5730orange\u914d\u7f6e->" + JSON.toJSONString((Object)this.orangeBean));
            }
        }
        catch (Exception exception) {
            LogUtils.e(TAG, exception);
            TanxBaseUt.utError(UtErrorCode.CRASH_ERROR.getIntCode(), TAG, LogUtils.getStackTraceMessage(exception), "");
        }
        this.checkAndCreateDefaultOrange();
    }

    private void writeOrange(OrangeBean orangeBean) {
        try {
            LogUtils.d(TAG, "\u8986\u76d6\u672c\u5730orange\u914d\u7f6e->" + JSON.toJSONString((Object)orangeBean));
            SharedPreferencesHelper sharedPreferencesHelper = SharedPreferencesHelper.getInstance();
            SharedPreferencesHelper.getInstance();
            sharedPreferencesHelper.putString("KEY_ORANGE", JSON.toJSONString((Object)orangeBean));
        }
        catch (Exception exception) {
            LogUtils.e(TAG, exception);
            TanxBaseUt.utError(UtErrorCode.CRASH_ERROR.getIntCode(), TAG, LogUtils.getStackTraceMessage(exception), "");
        }
    }

    public String getFromAssets(String fileName) {
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(TanxCoreSdk.getApplication().getResources().getAssets().open(fileName));
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string = "";
            String string2 = "";
            while ((string = bufferedReader.readLine()) != null) {
                string2 = string2 + string;
            }
            return string2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "";
        }
    }

    public OrangeBean getOrangeBean() {
        return this.orangeBean;
    }

    private void callBack() {
        if (this.orangeInitListener != null) {
            this.orangeInitListener.initFinish(this.orangeBean);
        }
    }

    public boolean getAdSwitch(String adSwitchKey) {
        if (this.orangeBean == null || this.orangeBean.adSwitch == null || this.orangeBean.adSwitch.get(adSwitchKey) == null) {
            return true;
        }
        return this.orangeBean.adSwitch.get(adSwitchKey);
    }

    public HashMap<String, Boolean> getInstallSwitch() {
        if (this.orangeBean == null || this.orangeBean.installStatusSwitch == null) {
            return new HashMap<String, Boolean>();
        }
        return this.orangeBean.installStatusSwitch;
    }

    public String getFeedInteractionGifUrlParam(String feedInteractionParamKey) {
        String string = "https://img.alicdn.com/imgextra/i3/O1CN01yaPRML1GyyqsOZP7R_!!6000000000692-1-tps-1200-432.gif";
        if (this.orangeBean == null || this.orangeBean.feedInteractionParam == null) {
            return string;
        }
        String string2 = this.orangeBean.feedInteractionParam.get(feedInteractionParamKey);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return string;
        }
        return string2;
    }

    public int getFeedInteractionParam2Integer(String feedInteractionParamKey) {
        try {
            if (this.orangeBean == null || this.orangeBean.feedInteractionParam == null) {
                return this.defaultFeedInteractionParam(feedInteractionParamKey);
            }
            String string = this.orangeBean.feedInteractionParam.get(feedInteractionParamKey);
            if (TextUtils.isEmpty((CharSequence)string)) {
                return this.defaultFeedInteractionParam(feedInteractionParamKey);
            }
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    private int defaultFeedInteractionParam(String feedInteractionParamKey) {
        int n = 55;
        int n2 = 120;
        int n3 = 1;
        switch (feedInteractionParamKey) {
            case "directionSlideDistance": {
                return n;
            }
            case "allSlideDistance": {
                return n2;
            }
            case "slideDirection": {
                return n3;
            }
        }
        return -1;
    }
}

