/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.core.request;

import android.app.Application;
import android.content.Context;
import android.graphics.Point;
import android.os.SystemClock;
import com.alibaba.fastjson.JSON;
import com.alimm.tanx.core.SdkConstant;
import com.alimm.tanx.core.TanxCoreManager;
import com.alimm.tanx.core.TanxCoreSdk;
import com.alimm.tanx.core.ad.bean.AdInfo;
import com.alimm.tanx.core.net.NetWorkManager;
import com.alimm.tanx.core.net.bean.RequestBean;
import com.alimm.tanx.core.net.callback.AdNetWorkCallBack;
import com.alimm.tanx.core.net.callback.NetWorkCallBack;
import com.alimm.tanx.core.request.AdRequestBean;
import com.alimm.tanx.core.request.C;
import com.alimm.tanx.core.request.TanxAdSlot;
import com.alimm.tanx.core.request.tanxc_do;
import com.alimm.tanx.core.ut.UtErrorCode;
import com.alimm.tanx.core.ut.impl.TanxCommonUt;
import com.alimm.tanx.core.utils.AndroidUtils;
import com.alimm.tanx.core.utils.DeviceIdGetUtil;
import com.alimm.tanx.core.utils.LogUtils;
import com.alimm.tanx.core.utils.NetWorkUtil;
import com.alimm.tanx.core.utils.SysUtils;
import java.util.ArrayList;
import java.util.HashMap;

public class AdRequest {
    private static final String TAG = "AdRequest";
    private static AdRequestBean adRequestBean;
    private static long sTime;
    private static long localTime;

    public static void request(final TanxAdSlot adSlot, final String scene, final NetWorkCallBack<AdInfo> callBack) {
        sTime = System.currentTimeMillis();
        DeviceIdGetUtil.getInstance(TanxCoreSdk.getApplication()).netGetImei();
        RequestBean requestBean = new RequestBean().setUrl(C.getAdUrl()).build();
        requestBean.setOverrideError(true);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Content-Type", "application/json; charset=utf-8");
        requestBean.setHeads(hashMap);
        adRequestBean = AdRequest.buildRequestBean(adRequestBean, adSlot);
        final String string = JSON.toJSONString((Object)adRequestBean);
        LogUtils.d(TAG, string);
        requestBean.setJson(string);
        localTime = System.currentTimeMillis() - sTime;
        LogUtils.d("splashTimeConsuming", "local->" + localTime);
        final long l = SystemClock.elapsedRealtime();
        NetWorkManager.getInstance().sendHttpPost(requestBean, AdInfo.class, (NetWorkCallBack)new AdNetWorkCallBack<AdInfo>(){

            @Override
            public void error(int code, String error) {
                if (callBack != null) {
                    callBack.error(code, error);
                    TanxCommonUt.sendAdRqFail(scene, adSlot.getPid(), adRequestBean.id, SystemClock.elapsedRealtime() - l, code, error, string);
                }
            }

            public void tanxc_do(AdInfo adInfo) {
                AdRequest.suc(adInfo, "", string, l, adSlot, scene, callBack);
            }

            public void tanxc_do(AdInfo adInfo, String string2) {
                AdRequest.suc(adInfo, string2, string, l, adSlot, scene, callBack);
            }

            @Override
            public /* synthetic */ void succ(Object object, String string2) {
                this.tanxc_do((AdInfo)object, string2);
            }

            @Override
            public /* synthetic */ void succ(Object object) {
                this.tanxc_do((AdInfo)object);
            }
        });
    }

    private static void suc(AdInfo adInfo, String decrypt, String requestInfo, long requestStartTime, TanxAdSlot adSlot, String scene, NetWorkCallBack<AdInfo> callBack) {
        if (callBack != null) {
            if (adInfo != null && (adInfo.getStatus() == 0 || adInfo.getStatus() == 1)) {
                adInfo.setDecrypt(decrypt);
                callBack.succ(tanxc_do.tanxc_do(adInfo));
                TanxCommonUt.sendAdRqSuc(scene, adSlot, adInfo.getRequestId(), SystemClock.elapsedRealtime() - requestStartTime, adInfo.getAdCount(), adInfo);
            } else {
                UtErrorCode utErrorCode = UtErrorCode.DATA_PARSE_ERROR;
                callBack.error(utErrorCode.getIntCode(), utErrorCode.getMsg());
                TanxCommonUt.sendAdRqFail(scene, adSlot.getPid(), AdRequest.adRequestBean.id, SystemClock.elapsedRealtime() - requestStartTime, utErrorCode.getIntCode(), utErrorCode.getMsg(), requestInfo);
            }
        }
    }

    private static AdRequestBean buildRequestBean(AdRequestBean bean, TanxAdSlot adSlot) {
        AdRequestBean.AdImpBean adImpBean;
        Application application = TanxCoreManager.getInstance().getAppContext();
        AdRequestBean adRequestBean = bean;
        if (adRequestBean == null) {
            adRequestBean = new AdRequestBean();
        }
        if (adRequestBean.app == null) {
            adRequestBean.app = new AdRequestBean.AdAppBean();
            adRequestBean.app.package_name = AndroidUtils.getPackageName((Context)application);
            adRequestBean.app.app_name = AndroidUtils.getAppName((Context)application);
            adRequestBean.app.app_version = AndroidUtils.getAppVersion((Context)application, adRequestBean.app.package_name);
            adRequestBean.app.sdk_version = SdkConstant.getSdkVersion();
        }
        adRequestBean.imp = new ArrayList<AdRequestBean.AdImpBean>();
        for (int i = 0; i < adSlot.getAdCount(); ++i) {
            adImpBean = new AdRequestBean.AdImpBean();
            adImpBean.pid = adSlot.getPid();
            adImpBean.native_template_id = adSlot.getNativeTemplateId();
            adImpBean.slot_num = 1;
            adImpBean.id = String.valueOf(i);
            adRequestBean.imp.add(adImpBean);
        }
        if (adRequestBean.device == null) {
            AdRequestBean.AdDeviceBean adDeviceBean;
            adRequestBean.device = adDeviceBean = new AdRequestBean.AdDeviceBean();
            adDeviceBean.user_agent = AndroidUtils.getUserAgent();
            adDeviceBean.android_id = AndroidUtils.getAndroidId();
            adDeviceBean.device_type = 0;
            adDeviceBean.brand = AndroidUtils.getBrand();
            adDeviceBean.model = AndroidUtils.getModel();
            adDeviceBean.os = "Android";
            adDeviceBean.osv = AndroidUtils.getSystemVersion();
            adDeviceBean.network = NetWorkUtil.getNetworkType((Context)application).getKey();
            adRequestBean.device.operator = NetWorkUtil.getOperatorType((Context)application);
            adImpBean = AndroidUtils.getScreenSize((Context)application);
            adDeviceBean.width = ((Point)adImpBean).x;
            adDeviceBean.height = ((Point)adImpBean).y;
            adDeviceBean.pixel_ratio = AndroidUtils.getDisplayDpi((Context)application);
        }
        adRequestBean.device.installed_app = SysUtils.getInstallStatus();
        adRequestBean.device.imei = TanxCoreSdk.getConfig().getImei();
        adRequestBean.device.oaid = TanxCoreSdk.getConfig().getOaid();
        adRequestBean.device.clientId = TanxCoreSdk.getConfig().getClientId();
        adRequestBean.device.widevineId = TanxCoreSdk.getConfig().getWidevineId();
        adRequestBean.device.pseudoId = TanxCoreSdk.getConfig().getPseudoId();
        adRequestBean.device.guid = TanxCoreSdk.getConfig().getGuid();
        adRequestBean.device.orientation = AndroidUtils.getScreenOrientation((Context)application);
        adRequestBean.https_required = true;
        adRequestBean.version = 1;
        adRequestBean.id = adSlot.getReqId();
        adRequestBean.render_type = adSlot.isExpressRender() ? 1 : 2;
        return adRequestBean;
    }

    static {
        sTime = 0L;
        localTime = 0L;
    }
}

