/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.core.request;

import com.alimm.tanx.core.constant.TanxAdTemplateId;
import java.io.Serializable;
import java.util.UUID;

public class TanxAdSlot
implements Serializable {
    private String reqId;
    private int adType;
    private int adCount = 1;
    private String pid;
    private String[] nativeTemplateId;
    private int width;
    private int height;
    private boolean isExpressRender;
    private String userId = "defaultUser";
    private String mediaExtra = "";
    private int orientation = 1;

    public TanxAdSlot() {
        this.adCount = 1;
    }

    public TanxAdSlot(Builder builder) {
        this.adType = builder.adType;
        this.pid = builder.pid;
        this.nativeTemplateId = builder.nativeTemplateId;
        this.adCount = Math.max(builder.adCount, 1);
        this.width = builder.width;
        this.height = builder.height;
        this.reqId = this.uuid();
    }

    public int getAdType() {
        return this.adType;
    }

    public void setAdType(int adType) {
        this.adType = adType;
    }

    public int getAdCount() {
        return this.adCount;
    }

    public void setAdCount(int adCount) {
        this.adCount = adCount;
    }

    public String getPid() {
        return this.pid;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    public String[] getNativeTemplateId() {
        return this.nativeTemplateId;
    }

    public void setNativeTemplateId(String[] nativeTemplateId) {
        this.nativeTemplateId = nativeTemplateId;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public boolean isExpressRender() {
        return this.isExpressRender;
    }

    public void setExpressRender(boolean expressRender) {
        this.isExpressRender = expressRender;
    }

    public String getReqId() {
        return this.reqId;
    }

    public void setReqId(String reqId) {
        this.reqId = reqId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getMediaExtra() {
        return this.mediaExtra;
    }

    public void setMediaExtra(String mediaExtra) {
        this.mediaExtra = mediaExtra;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public void addAdSlot(int adType) {
        this.setAdSlot(adType);
        this.setExpressRender(false);
    }

    public void addTemplateAdSlot(int adType) {
        this.setAdSlot(adType);
        this.setExpressRender(true);
    }

    private void setAdSlot(int adType) {
        this.setAdType(adType);
        switch (adType) {
            case 1: {
                this.setNativeTemplateId(TanxAdTemplateId.SPLASH_TEMPLATE);
                break;
            }
            case 2: {
                this.setNativeTemplateId(TanxAdTemplateId.FEED_TEMPLATE);
                break;
            }
            case 3: {
                this.setNativeTemplateId(TanxAdTemplateId.REWARD_VIDEO_TEMPLATE);
                break;
            }
        }
    }

    private String uuid() {
        String string = UUID.randomUUID().toString();
        return string.replace("-", "") + "-" + System.currentTimeMillis() / 1000L;
    }

    public static class Builder {
        private int adType;
        private int adCount = 1;
        private String pid;
        private int width;
        private int height;
        private String[] nativeTemplateId;
        private boolean isExpressRender;
        private String userId = "defaultUser";
        private String mediaExtra = "";
        private int orientation = 1;

        public Builder pid(String pid) {
            this.pid = pid;
            return this;
        }

        @Deprecated
        public Builder nativeTemplateId(String[] nativeTemplateId) {
            this.nativeTemplateId = nativeTemplateId;
            return this;
        }

        public Builder adCount(int count) {
            this.adCount = count;
            return this;
        }

        public Builder adSize(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        @Deprecated
        public Builder adType(int adType) {
            this.adType = adType;
            return this;
        }

        public Builder isExpressRender(boolean isExpressRender) {
            this.isExpressRender = isExpressRender;
            return this;
        }

        public Builder setUserId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder setMediaExtra(String mediaExtra) {
            this.mediaExtra = mediaExtra;
            return this;
        }

        public Builder setOrientation(int orientation) {
            this.orientation = orientation;
            return this;
        }

        public TanxAdSlot build() {
            return new TanxAdSlot(this);
        }
    }
}

