/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.core.ut;

import com.alimm.tanx.core.orange.OrangeManager;
import com.alimm.tanx.core.orange.bean.OrangeBean;
import com.alimm.tanx.core.ut.IUserTracker;
import com.alimm.tanx.core.ut.bean.UtItemBean;
import com.alimm.tanx.core.ut.core.UserReportManager;
import com.alimm.tanx.core.utils.LogUtils;
import com.alimm.tanx.core.utils.TanxTestLog;
import java.util.Map;

public class AdUtAnalytics
implements IUserTracker {
    private static final String TAG = "AdUtAnalytics";
    private static AdUtAnalytics sInstance;

    private AdUtAnalytics() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AdUtAnalytics getInstance() {
        if (sInstance != null) return sInstance;
        Class<AdUtAnalytics> clazz = AdUtAnalytics.class;
        synchronized (AdUtAnalytics.class) {
            if (sInstance != null) return sInstance;
            sInstance = new AdUtAnalytics();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public void send(String page, String pid, String reqId, int eventId, String arg1, String arg2, String arg3, Map<String, String> args, String sessionId) {
        this.send(page, pid, reqId, eventId, 0, arg1, arg2, arg3, args, sessionId);
    }

    public void send(String page, String pid, String reqId, int eventId, int eventStatus, String arg1, String arg2, String arg3, Map<String, String> args, String sessionId) {
        LogUtils.d(TAG, "sendUtData: page = " + page + ",event = " + eventId + ",eventStatus = " + eventStatus + ",arg1 = " + arg1 + ",arg2 = " + arg2 + ",arg3 = " + arg3 + ",args = " + args);
        try {
            if (!AdUtAnalytics.isOpen(page)) {
                return;
            }
            if (OrangeManager.getInstance().getOrangeBean() != null) {
                args.put("orangeVersion", OrangeManager.getInstance().getOrangeBean().version + "");
            }
            UtItemBean utItemBean = new UtItemBean(reqId, pid, page, eventId, eventStatus, arg1, arg2, arg3, args, sessionId);
            UserReportManager.getInstance().send(utItemBean);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            LogUtils.d(TAG, "send UT exception.", exception);
        }
        TanxTestLog.sendLog(page, args);
    }

    @Override
    public void track(String page, String pid, String reqId, int eventId, String arg1, String arg2, String arg3, Map<String, String> args, String sessionId) {
        this.send(page, pid, reqId, eventId, arg1, arg2, arg3, args, sessionId);
    }

    public static boolean isOpen(String page) {
        OrangeBean orangeBean = OrangeManager.getInstance().getOrangeBean();
        if (orangeBean != null && orangeBean.commonSwitch != null && orangeBean.commonSwitch.containsKey(page)) {
            String string = orangeBean.commonSwitch.get(page);
            return "true".equalsIgnoreCase(string);
        }
        return true;
    }
}

