/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.core.ut.core;

import android.content.Context;
import com.alibaba.fastjson.JSON;
import com.alimm.tanx.core.TanxCoreSdk;
import com.alimm.tanx.core.ut.bean.UtBean;
import com.alimm.tanx.core.ut.core.thread.FileThreadPool;
import com.alimm.tanx.core.utils.FileUtil;
import com.alimm.tanx.core.utils.FileUtils;
import com.alimm.tanx.core.utils.LogUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class CacheUserReportManager {
    public static volatile int tempFileName = 0;
    private static final String TAG = "CacheUserReportManager";
    private static volatile CacheUserReportManager instance;
    private File cacheDir = FileUtils.mkdir(FileUtils.getExternalDir((Context)TanxCoreSdk.getApplication(), 0).getPath() + "/ut/");
    private final int FILE_MAX_SIZE = 1000;
    @Deprecated
    private final int FILE_MERGE_SIZE = 5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CacheUserReportManager getInstance() {
        if (null != instance) return instance;
        Class<CacheUserReportManager> clazz = CacheUserReportManager.class;
        synchronized (CacheUserReportManager.class) {
            if (null != instance) return instance;
            instance = new CacheUserReportManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void saveFile(UtBean utBean) {
        this.saveFile(JSON.toJSONString((Object)utBean));
    }

    public void saveFile(final String utStr) {
        FileThreadPool.post(new Runnable(){

            @Override
            public void run() {
                CacheUserReportManager.this.judgeFileDelete();
                File file = FileUtil.getAndCreateFile(CacheUserReportManager.this.cacheDir.getPath(), CacheUserReportManager.this.createFileName());
                FileUtils.saveStr2File(file, utStr);
            }
        });
    }

    private void judgeFileDelete() {
        try {
            if (this.cacheDir != null) {
                File[] fileArray = this.cacheDir.listFiles();
                if (fileArray != null && fileArray.length > 0) {
                    LogUtils.d(TAG, "UserReport :judgeFileDelete()\u6587\u4ef6\u4e2a\u6570->" + fileArray.length);
                    if (fileArray.length >= 1000) {
                        ArrayList<File> arrayList = new ArrayList<File>(Arrays.asList(fileArray));
                        Collections.sort(arrayList, new Comparator<File>(){

                            @Override
                            public int compare(File o1, File o2) {
                                long l = FileUtil.getFileName(o1);
                                long l2 = FileUtil.getFileName(o2);
                                return (int)(l2 - l);
                            }
                        });
                        while (arrayList.size() - 1000 >= 0) {
                            File file = (File)arrayList.get(arrayList.size() - 1);
                            FileUtils.deleteFile(file);
                            arrayList.remove(arrayList.size() - 1);
                            LogUtils.d(TAG, "UserReport :judgeFileDelete(),\u8d85\u8fc7\u6587\u4ef6\u9608\u503c\u5f00\u59cb\u5220\u9664->\u5f53\u524d\u6587\u4ef6\u4e2a\u6570" + fileArray.length);
                        }
                    }
                } else {
                    LogUtils.d(TAG, "UserReport :judgeFileDelete()listFiles\u4e3a\u7a7a\uff0c\u6216length\u4e3a0");
                }
            }
        }
        catch (Exception exception) {
            LogUtils.e("UserReport :", exception);
        }
    }

    public void deleteFile(final File file) {
        FileThreadPool.post(new Runnable(){

            @Override
            public void run() {
                FileUtils.deleteFile(file);
            }
        });
    }

    private String createFileName() {
        return System.currentTimeMillis() + ".txt";
    }

    public List<File> readCacheFileList() {
        File[] fileArray = this.cacheDir.listFiles();
        ArrayList<File> arrayList = new ArrayList<File>();
        if (fileArray != null && fileArray.length > 0) {
            arrayList = new ArrayList<File>(Arrays.asList(fileArray));
        }
        return arrayList;
    }
}

