/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.core.ut.core;

import com.alimm.tanx.core.ut.bean.UtBean;
import com.alimm.tanx.core.ut.core.CacheUserReportManager;
import com.alimm.tanx.core.ut.core.UtRequest;
import com.alimm.tanx.core.ut.core.thread.CacheAddThreadPool;
import com.alimm.tanx.core.ut.core.thread.RealTimeAddThreadPool;
import com.alimm.tanx.core.ut.core.thread.UserReportThreadPool;
import com.alimm.tanx.core.utils.FileUtil;
import com.alimm.tanx.core.utils.LogUtils;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public class QueueManager {
    private static String TAG = "QueueManager";
    private static volatile QueueManager instance;
    private static final int QUEUE_SIZE = 1000;
    private static final int CATCH_DELAY_TIME = 10000;
    private volatile LinkedBlockingQueue<UtBean> realTimeLinkedBlockingQueue = new LinkedBlockingQueue(1000);
    private volatile boolean realTimeQueueRunning = false;
    private volatile boolean cacheRunning = false;
    private volatile AtomicBoolean destroy = new AtomicBoolean(false);
    private volatile ConcurrentHashMap<Long, File> catchFileConcurrentHashMap = new ConcurrentHashMap(1000);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static QueueManager getInstance() {
        if (null != instance) return instance;
        Class<QueueManager> clazz = QueueManager.class;
        synchronized (QueueManager.class) {
            if (null != instance) return instance;
            instance = new QueueManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void run() {
        LogUtils.d(TAG, "UserReport :run()");
        this.destroy.set(false);
        this.runRealTimeQueue();
        this.readCatch2Upload();
    }

    private void runRealTimeQueue() {
        LogUtils.d(TAG, "UserReport :\u542f\u52a8runRealTimeQueue--realTimeQueueRunning-->" + this.realTimeQueueRunning);
        if (!this.realTimeQueueRunning) {
            UserReportThreadPool.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        QueueManager.this.realTimeQueueRunning = true;
                        UtBean utBean = null;
                        while ((utBean = (UtBean)QueueManager.this.realTimeLinkedBlockingQueue.take()) != null) {
                            if (QueueManager.this.destroy.get()) {
                                LogUtils.d(TAG, "UserReport :\u540e\u53f0\u903b\u8f91\uff0c\u53d6\u51farealTimeLinkedBlockingQueue\u5143\u7d20\uff0c\u4fdd\u5b58\u5230\u6587\u4ef6");
                                QueueManager.this.destroyIng(utBean);
                                continue;
                            }
                            LogUtils.d(TAG, "UserReport :\u53d6\u51farealTimeLinkedBlockingQueue\u5143\u7d20\uff0c\u542f\u52a8\u4e0a\u62a5");
                            UtRequest.getInstance().requestRealTime(utBean);
                        }
                    }
                    catch (Exception exception) {
                        LogUtils.e(TAG, exception);
                        QueueManager.this.realTimeQueueRunning = false;
                    }
                }
            });
        }
    }

    private void runCatchQueue() {
        UtRequest.getInstance().atomicLong.set(0L);
        UserReportThreadPool.post(new Runnable(){

            @Override
            public void run() {
                try {
                    LogUtils.d(TAG, "UserReport :\u542f\u52a8runCatchQueue");
                    for (Map.Entry entry : QueueManager.this.catchFileConcurrentHashMap.entrySet()) {
                        LogUtils.d(TAG, "UserReport :\u53d6\u51facatchFileLinkedHashMap\u5143\u7d20\uff0c\u542f\u52a8\u4e0a\u62a5");
                        Long l = (Long)entry.getKey();
                        File file = (File)entry.getValue();
                        if (!file.exists()) {
                            QueueManager.this.catchFileConcurrentHashMap.remove(l);
                            continue;
                        }
                        boolean bl = UtRequest.getInstance().requestCache(file);
                        if (bl) {
                            LogUtils.d(TAG, "UserReport :\u57cb\u70b9catchFileConcurrentHashMap\u6210\u529f-> ");
                            QueueManager.this.catchFileConcurrentHashMap.remove(l);
                            CacheUserReportManager.getInstance().deleteFile(file);
                            continue;
                        }
                        LogUtils.d(TAG, "UserReport :\u57cb\u70b9catchFileConcurrentHashMap\u5931\u8d25");
                    }
                }
                catch (Exception exception) {
                    LogUtils.e(TAG, exception);
                }
                QueueManager.this.cacheRunning = false;
            }
        });
    }

    public void readCatch2Upload() {
        if (!this.cacheRunning) {
            LogUtils.d(TAG, "UserReport :\u5ef6\u8fdf10000\u6beb\u79d2 \u542f\u52a8readCatch2Upload,runCatchQueue");
            this.cacheRunning = true;
            CacheAddThreadPool.postDelayed(new Runnable(){

                @Override
                public void run() {
                    try {
                        List<File> list = CacheUserReportManager.getInstance().readCacheFileList();
                        LogUtils.d(TAG, "UserReport :\u6dfb\u52a0catchFileLinkedHashMap ->" + list.size());
                        for (int i = 0; i < list.size(); ++i) {
                            if (list.get(i) == null) continue;
                            QueueManager.this.addCatchList(list.get(i));
                        }
                        QueueManager.this.runCatchQueue();
                    }
                    catch (Exception exception) {
                        LogUtils.e(TAG, exception);
                    }
                }
            }, 10000);
        } else {
            LogUtils.d(TAG, "UserReport :readCatch2Upload\u5df2\u7ecf\u542f\u52a8\uff0c\u65e0\u9700\u91cd\u590d\u542f\u52a8->cacheRunning->" + this.cacheRunning);
        }
    }

    public void addRealTimeQueue(UtBean itemUtBean) {
        RealTimeRunnable realTimeRunnable = new RealTimeRunnable(itemUtBean);
        RealTimeAddThreadPool.post(realTimeRunnable);
    }

    public void addCatchList(File file) {
        try {
            if (file != null) {
                this.catchFileConcurrentHashMap.put(FileUtil.getFileName(file), file);
            } else {
                LogUtils.d(TAG, "UserReport :\u6dfb\u52a0catchFileLinkedHashMap\u5931\u8d25-->itemUtBean\u4e3a\u7a7a");
            }
        }
        catch (Exception exception) {
            LogUtils.e(TAG, exception);
        }
    }

    private void destroyIng(final UtBean utBean) {
        RealTimeAddThreadPool.post(new Runnable(){

            @Override
            public void run() {
                try {
                    CacheUserReportManager.getInstance().saveFile(utBean);
                }
                catch (Exception exception) {
                    LogUtils.e("UserReport :", exception);
                }
            }
        });
    }

    public void destroy() {
        this.destroy.set(true);
    }

    class RealTimeRunnable
    implements Runnable {
        private final String TAG = "RealTimeRunnable";
        private UtBean itemUtBean;

        public RealTimeRunnable(UtBean itemUtBean) {
            this.itemUtBean = itemUtBean;
        }

        @Override
        public void run() {
            try {
                LogUtils.d("RealTimeRunnable", "UserReport :\u6dfb\u52a0addRealTimeQueue");
                if (this.itemUtBean != null) {
                    QueueManager.this.realTimeLinkedBlockingQueue.put(this.itemUtBean);
                } else {
                    LogUtils.d("RealTimeRunnable", "UserReport :\u6dfb\u52a0addRealTimeQueue\u5931\u8d25-->itemUtBean\u4e3a\u7a7a");
                }
            }
            catch (Exception exception) {
                LogUtils.e("RealTimeRunnable", exception);
            }
        }
    }
}

