/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.core.ut.core;

import com.alibaba.fastjson.JSON;
import com.alimm.tanx.core.net.NetWorkManager;
import com.alimm.tanx.core.net.bean.RequestBean;
import com.alimm.tanx.core.request.C;
import com.alimm.tanx.core.ut.bean.UtBean;
import com.alimm.tanx.core.ut.bean.UtResponse;
import com.alimm.tanx.core.ut.core.CacheUserReportManager;
import com.alimm.tanx.core.utils.FileUtils;
import com.alimm.tanx.core.utils.LogUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class UtRequest {
    private static final String TAG = "UtRequest";
    private volatile ConcurrentHashMap<Integer, UtBean> ingConcurrentHashMap = new ConcurrentHashMap();
    private static volatile UtRequest instance;
    public AtomicLong atomicLong = new AtomicLong(0L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UtRequest getInstance() {
        if (instance != null) return instance;
        Class<UtRequest> clazz = UtRequest.class;
        synchronized (UtRequest.class) {
            if (instance != null) return instance;
            instance = new UtRequest();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private boolean request(UtBean utBeans, boolean isCacheRequest) {
        if (!isCacheRequest) {
            this.ingConcurrentHashMap.put(utBeans.hashCode(), utBeans);
            LogUtils.d(TAG, "request ->ingListLinkedHashMap->size():" + this.ingConcurrentHashMap.size());
        }
        RequestBean requestBean = new RequestBean().setUrl(C.getUtUrl()).build();
        requestBean.setOverrideError(true);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Content-Type", "application/json; charset=utf-8");
        requestBean.setHeads(hashMap);
        LogUtils.d(TAG, utBeans.toString());
        requestBean.setJson(JSON.toJSONString((Object)utBeans));
        UtResponse utResponse = NetWorkManager.getInstance().sendSyncHttpPost2Gzip(requestBean, UtResponse.class);
        if (utResponse != null) {
            boolean bl;
            boolean bl2 = bl = utResponse.status == 0;
            if (bl) {
                LogUtils.d(TAG, "UserReport :succ");
                if (!isCacheRequest) {
                    this.removeIngMap(utBeans);
                }
                LogUtils.d(TAG, "UserReport :succ ->\u4e0a\u62a5\u6210\u529f->:" + this.atomicLong.incrementAndGet());
            } else {
                if (!isCacheRequest) {
                    LogUtils.d(TAG, "UserReport :error ");
                    this.removeIngMap(utBeans);
                    CacheUserReportManager.getInstance().saveFile(requestBean.getJson());
                }
                LogUtils.d(TAG, "UserReport :error ->\u4e0a\u62a5\u5931\u8d25->:" + this.atomicLong.incrementAndGet() + " \u670d\u52a1\u5668\u9519\u8bef\u4fe1\u606f\uff1a" + utResponse.msg);
            }
            return bl;
        }
        LogUtils.e(TAG, "UserReport :error ->\u4e0a\u62a5\u5931\u8d25->:\u670d\u52a1\u5668\u8fd4\u56de\u7a7aUtResponse reqId:" + utBeans.reqId);
        if (!isCacheRequest) {
            this.removeIngMap(utBeans);
            CacheUserReportManager.getInstance().saveFile(requestBean.getJson());
        }
        return false;
    }

    private void removeIngMap(UtBean utBean) {
        try {
            if (utBean != null) {
                UtBean utBean2 = this.ingConcurrentHashMap.get(utBean.hashCode());
                String string = "";
                if (utBean2 != null) {
                    string = utBean2.toString();
                }
                LogUtils.d(TAG, "UserReport :ingListLinkedHashMap -remove\u524d ->size():" + this.ingConcurrentHashMap.size() + "->ingConcurrentHashMap.get()->" + string);
                this.ingConcurrentHashMap.remove(utBean.hashCode());
                LogUtils.d(TAG, "UserReport :ingListLinkedHashMap-remove\u540e->size():" + this.ingConcurrentHashMap.size());
            } else {
                LogUtils.d(TAG, "UserReport :ingListLinkedHashMap-remove \u8fc7\u7a0b\u4e3a\u7a7a");
            }
        }
        catch (Exception exception) {
            LogUtils.e("UserReport :", exception);
        }
    }

    public boolean requestRealTime(UtBean utBeans) {
        return this.request(utBeans, false);
    }

    public boolean requestCache(File file) {
        String string = FileUtils.getStrFromFile(file);
        try {
            UtBean utBean = (UtBean)JSON.parseObject((String)string, UtBean.class);
            return this.request(utBean, true);
        }
        catch (Exception exception) {
            LogUtils.e("UserReport :", exception);
            return false;
        }
    }

    public void destroy() {
        try {
            for (Map.Entry<Integer, UtBean> entry : this.ingConcurrentHashMap.entrySet()) {
                LogUtils.d(TAG, "UserReport :\u53d6\u51facatchFileLinkedHashMap\u5143\u7d20\uff0c\u542f\u52a8\u4e0a\u62a5");
                UtBean utBean = entry.getValue();
                CacheUserReportManager.getInstance().saveFile(utBean);
            }
            this.ingConcurrentHashMap.clear();
        }
        catch (Exception exception) {
            LogUtils.e("UserReport :", exception);
        }
    }
}

