/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.core.ut.core.thread;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.alimm.tanx.core.utils.LogUtils;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class CacheAddThreadPool {
    private static final String TAG = "UserReportAddThreadPool";
    private static final int CORE_POOL_SIZE = 1;
    private static final int MAX_POOL_SIZE = 1;
    private static final int KEEP_ALIVE_SECONDS = 60;
    private static final int DEFAULT_QUEUE_SIZE = 100;
    private static long sIndex = 0L;
    private static ThreadPoolExecutor sExecutor = new ThreadPoolExecutor(1, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(100), new ThreadFactory(){

        @Override
        public Thread newThread(@NonNull Runnable r) {
            return new Thread(r, "UserReportAddThreadPool-" + sIndex++);
        }
    });
    private static Handler sHandler;

    public static void post(@NonNull Runnable runnable) {
        try {
            sExecutor.execute(runnable);
        }
        catch (Throwable throwable) {
            LogUtils.d(TAG, "UserReport :post exception", throwable);
        }
    }

    public static void postDelayed(final @NonNull Runnable runnable, int delayTimeMills) {
        if (delayTimeMills == 0) {
            CacheAddThreadPool.post(runnable);
        } else if (delayTimeMills > 0) {
            if (sHandler == null) {
                sHandler = new Handler(Looper.getMainLooper());
            }
            sHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    CacheAddThreadPool.post(runnable);
                }
            }, (long)delayTimeMills);
        }
    }

    public static void removeTask(@NonNull Runnable runnable) {
        if (sHandler != null) {
            sHandler.removeCallbacks(runnable);
        }
    }

    static {
        sExecutor.allowCoreThreadTimeOut(true);
        sExecutor.setRejectedExecutionHandler(new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            }
        });
    }
}

