/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.core.utils;

import android.app.Activity;
import android.os.Build;
import android.support.v4.view.MenuItemCompat;
import android.text.TextUtils;
import android.view.Menu;
import android.view.MenuItem;
import android.webkit.WebBackForwardList;
import android.webkit.WebHistoryItem;
import android.webkit.WebView;
import com.alimm.tanx.core.ad.view.ActionMenu;
import com.alimm.tanx.core.utils.LogUtils;

public class AdWebViewUtils {
    private static final String TAG = "AdClickUtils";

    public static boolean isDestroyed(Activity activity) {
        return activity == null || activity.isFinishing() || Build.VERSION.SDK_INT >= 17 && activity.isDestroyed();
    }

    public static void setShowAsAction(Menu menu, ActionMenu item) {
        MenuItem menuItem = menu.add(0, item.id, 0, (CharSequence)item.name);
        menuItem.setIcon(item.drawable);
        MenuItemCompat.setShowAsAction((MenuItem)menuItem, (int)2);
    }

    public static boolean isNormalWebTitleValid(CharSequence title, WebView webView) {
        String string = null;
        WebBackForwardList webBackForwardList = null;
        try {
            WebHistoryItem webHistoryItem;
            if (null != webView) {
                webBackForwardList = webView.copyBackForwardList();
            }
            if (null != webBackForwardList && null != (webHistoryItem = webBackForwardList.getCurrentItem())) {
                string = webHistoryItem.getUrl();
            }
        }
        catch (Throwable throwable) {
            LogUtils.d(TAG, "isNormalWebTitleValid exception: title = " + title, throwable);
        }
        LogUtils.d(TAG, "isNormalWebTitleValid: url = " + string + ", title = " + title);
        return string != null && !TextUtils.isEmpty((CharSequence)title) && !string.toLowerCase().contains(title instanceof String ? ((String)title).toLowerCase() : title);
    }
}

