/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.core.utils;

import android.content.Context;
import android.text.TextUtils;
import android.util.Base64;
import com.alimm.tanx.core.TanxCoreSdk;
import com.alimm.tanx.core.ut.UtErrorCode;
import com.alimm.tanx.core.ut.impl.TanxBaseUt;
import com.alimm.tanx.core.utils.LogUtils;
import com.alimm.tanx.core.utils.MD5Utils;
import com.alimm.tanx.core.utils.SharedPreferencesHelper;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class AesUtil {
    private static String password = "";

    public static String encrypt(String password, String input) throws UnsupportedEncodingException, GeneralSecurityException {
        String string = AesUtil.getRandomIV();
        IvParameterSpec ivParameterSpec = new IvParameterSpec(string.getBytes("UTF-8"));
        SecretKey secretKey = AesUtil.deriveKey(password, string);
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
        cipher.init(1, (Key)secretKey, ivParameterSpec);
        byte[] byArray = cipher.doFinal(input.getBytes());
        return AesUtil.getMd5AppId() + string + Base64.encodeToString((byte[])byArray, (int)2);
    }

    public static String decrypt(String password, String input) throws UnsupportedEncodingException, GeneralSecurityException {
        String string = input.substring(32);
        String string2 = string.substring(0, 16);
        string = string.substring(16);
        IvParameterSpec ivParameterSpec = new IvParameterSpec(string2.getBytes("UTF-8"));
        SecretKey secretKey = AesUtil.deriveKey(password, string2);
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
        cipher.init(2, (Key)secretKey, ivParameterSpec);
        byte[] byArray = cipher.doFinal(Base64.decode((String)string, (int)2));
        return new String(byArray);
    }

    private static String getRandomIV() {
        Random random = new Random();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            stringBuilder.append((char)(random.nextInt(96) + 32));
        }
        return stringBuilder.toString();
    }

    private static String getMd5AppId() {
        return MD5Utils.getMD5String(TanxCoreSdk.getConfig().getAppKey());
    }

    private static SecretKey deriveKey(String password, String salt) throws NoSuchAlgorithmException, InvalidKeySpecException {
        char[] cArray = new char[password.length()];
        password.getChars(0, password.length(), cArray, 0);
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray, salt.getBytes(), 2000, 256);
        return new SecretKeySpec(secretKeyFactory.generateSecret(pBEKeySpec).getEncoded(), "AES");
    }

    public static String getPassWord(Context cxt) {
        try {
            if (!TextUtils.isEmpty((CharSequence)password)) {
                return password;
            }
        }
        catch (Exception exception) {
            LogUtils.e("security---->>>>>>>", exception.getMessage() + "");
            TanxBaseUt.utError(UtErrorCode.CRASH_ERROR.getIntCode(), "security---->>>>>>>", LogUtils.getStackTraceMessage(exception), "");
        }
        return password;
    }

    public static String encrypt(String json) {
        try {
            if (TanxCoreSdk.getConfig().isDebugMode()) {
                if (SharedPreferencesHelper.getInstance().getEncryptBoolean()) {
                    return AesUtil.encrypt(AesUtil.getPassWord((Context)TanxCoreSdk.getApplication()), json);
                }
                return json;
            }
            return AesUtil.encrypt(AesUtil.getPassWord((Context)TanxCoreSdk.getApplication()), json);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            LogUtils.e("encrypt", exception);
            TanxBaseUt.utError(UtErrorCode.CRASH_ERROR.getIntCode(), "encrypt", LogUtils.getStackTraceMessage(exception), "");
            return "";
        }
    }

    public static String decrypt(String decryptStr) {
        try {
            if (TanxCoreSdk.getConfig().isDebugMode()) {
                if (SharedPreferencesHelper.getInstance().getEncryptBoolean()) {
                    return AesUtil.decrypt(AesUtil.getPassWord((Context)TanxCoreSdk.getApplication()), decryptStr);
                }
                return decryptStr;
            }
            return AesUtil.decrypt(AesUtil.getPassWord((Context)TanxCoreSdk.getApplication()), decryptStr);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            LogUtils.e("decryptStr", exception);
            TanxBaseUt.utError(UtErrorCode.CRASH_ERROR.getIntCode(), "decryptStr", LogUtils.getStackTraceMessage(exception), "");
            return decryptStr;
        }
    }
}

