/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.core.utils;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Point;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.alibaba.fastjson.JSON;
import com.alimm.tanx.core.TanxCoreSdk;
import com.alimm.tanx.core.request.AdRequestBean;
import com.alimm.tanx.core.ut.UtErrorCode;
import com.alimm.tanx.core.ut.impl.TanxBaseUt;
import com.alimm.tanx.core.utils.LogUtils;
import com.alimm.tanx.core.utils.NetWorkUtil;

public class AndroidUtils {
    private static final String TAG = "PackageUtils";
    private static AdRequestBean.AdDeviceBean deviceBean = null;

    public static String getPackageName(Context context) {
        return context.getPackageName();
    }

    public static String getAppName(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            int n = packageInfo.applicationInfo.labelRes;
            return context.getResources().getString(n);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
            return null;
        }
    }

    public static String getAppVersion(Context context, String packageName) {
        PackageManager packageManager = context.getPackageManager();
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo(packageName, 0);
            return packageInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
            return packageName;
        }
    }

    public static String getUserAgent() {
        return System.getProperty("http.agent");
    }

    public static String getAndroidId() {
        return "";
    }

    public static String getBrand() {
        return Build.BRAND;
    }

    public static String getModel() {
        return Build.MODEL;
    }

    public static String getSystemVersion() {
        return Build.VERSION.RELEASE;
    }

    public static Point getScreenSize(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        Point point = new Point();
        display.getSize(point);
        return point;
    }

    public static int getDisplayDpi(Context context) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        return displayMetrics.densityDpi;
    }

    public static int getScreenOrientation(Context context) {
        int n = context.getResources().getConfiguration().orientation;
        if (n == 1) {
            return 1;
        }
        if (n == 2) {
            return 2;
        }
        return 0;
    }

    public static AdRequestBean.AdDeviceBean getDeviceBean() {
        AndroidUtils.getDeviceInfo(true);
        return deviceBean;
    }

    public static AdRequestBean.AdDeviceBean getUtDeviceBean() {
        AndroidUtils.getDeviceInfo(false);
        return deviceBean;
    }

    public static String getDeviceInfo(boolean isCatchUtSwitch) {
        try {
            if (deviceBean == null) {
                deviceBean = new AdRequestBean.AdDeviceBean();
                AndroidUtils.deviceBean.user_agent = AndroidUtils.getUserAgent();
                AndroidUtils.deviceBean.android_id = AndroidUtils.getAndroidId();
                AndroidUtils.deviceBean.device_type = 0;
                AndroidUtils.deviceBean.brand = AndroidUtils.getBrand();
                AndroidUtils.deviceBean.model = AndroidUtils.getModel();
                AndroidUtils.deviceBean.os = "Android";
                AndroidUtils.deviceBean.osv = AndroidUtils.getSystemVersion();
                Point point = AndroidUtils.getScreenSize((Context)TanxCoreSdk.getApplication());
                AndroidUtils.deviceBean.width = point.x;
                AndroidUtils.deviceBean.height = point.y;
                AndroidUtils.deviceBean.pixel_ratio = AndroidUtils.getDisplayDpi((Context)TanxCoreSdk.getApplication());
            }
            AndroidUtils.deviceBean.network = NetWorkUtil.getNetworkType((Context)TanxCoreSdk.getApplication()).getKey();
            return JSON.toJSONString((Object)deviceBean);
        }
        catch (Exception exception) {
            LogUtils.e(exception);
            exception.printStackTrace();
            if (isCatchUtSwitch) {
                TanxBaseUt.utError(UtErrorCode.CRASH_ERROR.getIntCode(), TAG, LogUtils.getStackTraceMessage(exception), "");
            }
            return "";
        }
    }
}

