/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.core.utils;

import android.app.Application;
import android.content.Context;
import android.text.TextUtils;
import com.alimm.tanx.core.TanxCoreSdk;
import com.alimm.tanx.core.common.tanxc_do;
import com.alimm.tanx.core.ut.UtErrorCode;
import com.alimm.tanx.core.ut.impl.TanxBaseUt;
import com.alimm.tanx.core.utils.LogUtils;
import com.tanx.onlyid.api.DeviceIdManager;
import com.tanx.onlyid.api.IGetter;

public class DeviceIdGetUtil {
    private static final String TAG = "DeviceIdGetUtil-";
    private static DeviceIdGetUtil instance;
    private static Application application;
    private static final int IMEI_GET_MAX_COUNT = 2;
    private volatile int imeiGetNowCount = 0;

    private DeviceIdGetUtil() {
        DeviceIdManager.getInstance().init(application);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DeviceIdGetUtil getInstance(Application context) {
        if (null != instance) return instance;
        Class<DeviceIdManager> clazz = DeviceIdManager.class;
        synchronized (DeviceIdManager.class) {
            if (null != instance) return instance;
            application = context;
            instance = new DeviceIdGetUtil();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public void initId() {
        tanxc_do.tanxc_do(new Runnable(){

            @Override
            public void run() {
                try {
                    if (TanxCoreSdk.getConfig().isOaidSwitch()) {
                        DeviceIdGetUtil.this.getOaid();
                    } else {
                        LogUtils.d("DeviceIdGetUtil-oaidGet", "\u65e0\u9700\u83b7\u53d6\uff1aisOaidSwitch->" + TanxCoreSdk.getConfig().isOaidSwitch() + "\nnowOaid" + TanxCoreSdk.getConfig().getOaid());
                    }
                    if (TanxCoreSdk.getConfig().isImeiSwitch()) {
                        DeviceIdGetUtil.this.getImei();
                    } else {
                        LogUtils.d("DeviceIdGetUtil-imeiGet", "\u65e0\u9700\u83b7\u53d6\uff1aisImeiSwitch->" + TanxCoreSdk.getConfig().isImeiSwitch() + "\nnowImei" + TanxCoreSdk.getConfig().getImei());
                    }
                }
                catch (Exception exception) {
                    LogUtils.e("DeviceIdGetUtil-initAllId", exception);
                    TanxBaseUt.utError(UtErrorCode.CRASH_ERROR.getIntCode(), "DeviceIdGetUtil-initAllId", LogUtils.getStackTraceMessage(exception), "");
                }
            }
        });
    }

    public void getOaid() {
        final long l = System.currentTimeMillis();
        String string = TanxCoreSdk.getConfig().getOaid();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            TanxCoreSdk.getConfig().setmOaid(string);
        }
        DeviceIdManager.getInstance().getOAID((Context)application, new IGetter(){

            public void oaidSucc(String getOaid) {
                if (!TextUtils.isEmpty((CharSequence)getOaid)) {
                    TanxCoreSdk.getConfig().setmOaid(getOaid);
                }
                LogUtils.d("DeviceIdGetUtil-oaidGet", getOaid + "\ntime-> " + (System.currentTimeMillis() - l));
            }

            public void oaidError(Exception e) {
                LogUtils.e("DeviceIdGetUtil-oaidGet", e);
                TanxBaseUt.utError(UtErrorCode.CRASH_ERROR.getIntCode(), "DeviceIdGetUtil-oaidGet", LogUtils.getStackTraceMessage(e), "");
            }
        });
    }

    public void getImei() {
        String string = DeviceIdManager.getInstance().getIMEI((Context)application);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            TanxCoreSdk.getConfig().setImei(string);
        }
        LogUtils.d("DeviceIdGetUtil-imeiGet", string);
    }

    public void getClientId() {
        String string = DeviceIdManager.getInstance().getClientId();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            TanxCoreSdk.getConfig().setClientId(string);
        }
        LogUtils.d("DeviceIdGetUtil-clientIdGet", string);
    }

    public void getWidevineId() {
        String string = DeviceIdManager.getInstance().getWidevineID();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            TanxCoreSdk.getConfig().setWidevineId(string);
        }
        LogUtils.d("DeviceIdGetUtil-widevineIDGet", string);
    }

    public void getPseudoId() {
        String string = DeviceIdManager.getInstance().getPseudoID();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            TanxCoreSdk.getConfig().setPseudoId(string);
        }
        LogUtils.d("DeviceIdGetUtil-pseudoIdGet", string);
    }

    public void getGuid() {
        String string = DeviceIdManager.getInstance().getGUID((Context)application);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            TanxCoreSdk.getConfig().setGuid(string);
        }
        LogUtils.d("DeviceIdGetUtil-guidGet", string);
    }

    public void netGetImei() {
        if (this.imeiGetNowCount >= 2) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)TanxCoreSdk.getConfig().getImei()) && TextUtils.isEmpty((CharSequence)TanxCoreSdk.getConfig().getOaid()) && TanxCoreSdk.getConfig().isImeiSwitch()) {
            this.getImei();
            ++this.imeiGetNowCount;
        }
    }
}

