/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.core.utils;

import android.content.Context;
import android.os.Environment;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.ResponseBody;

public class FileUtil {
    public static synchronized File getAndCreateFile(String path, String fileName) {
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        return new File(file, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(ResponseBody responseBody, File file, long currentLength, boolean resume, WriteProgress listener) {
        InputStream inputStream = responseBody.byteStream();
        FileOutputStream fileOutputStream = null;
        try {
            long l = 0L;
            byte[] byArray = new byte[1024];
            int n = 0;
            fileOutputStream = resume ? new FileOutputStream(file, true) : new FileOutputStream(file);
            l = resume ? currentLength : 0L;
            while ((n = inputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
                int n2 = (int)((float)(l += (long)n) * 1.0f / (float)responseBody.contentLength() * 100.0f);
                listener.writeProgress(n2);
            }
            fileOutputStream.flush();
        }
        catch (Exception exception) {
            listener.error(exception);
            exception.printStackTrace();
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(String aOldPath, String aNewPath) {
        boolean bl = false;
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            int n = 0;
            File file = new File(aOldPath);
            if (file.exists()) {
                inputStream = new FileInputStream(aOldPath);
                fileOutputStream = new FileOutputStream(aNewPath);
                byte[] byArray = new byte[1444];
                while ((n = inputStream.read(byArray)) != -1) {
                    fileOutputStream.write(byArray, 0, n);
                }
                bl = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(InputStream inStream, FileOutputStream fs) {
        boolean bl = false;
        try {
            int n = 0;
            byte[] byArray = new byte[1444];
            while ((n = inStream.read(byArray)) != -1) {
                fs.write(byArray, 0, n);
            }
            bl = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (fs != null) {
                    fs.close();
                }
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return bl;
    }

    public static File getIndividualCacheDirectory(Context context, String dirName) {
        File file = FileUtil.getCacheDirectory(context, true);
        return new File(file, dirName);
    }

    private static File getCacheDirectory(Context context, boolean preferExternal) {
        String string;
        File file = null;
        try {
            string = Environment.getExternalStorageState();
        }
        catch (NullPointerException nullPointerException) {
            string = "";
        }
        if (preferExternal && "mounted".equals(string)) {
            file = FileUtil.getExternalCacheDir(context);
        }
        if (file == null) {
            file = context.getCacheDir();
        }
        if (file == null) {
            String string2 = "/data/data/" + context.getPackageName() + "/cache/";
            file = new File(string2);
        }
        return file;
    }

    private static File getExternalCacheDir(Context context) {
        File file = new File(new File(Environment.getExternalStorageDirectory(), "Android"), "data");
        File file2 = new File(new File(file, context.getPackageName()), "cache");
        if (!file2.exists() && !file2.mkdirs()) {
            return null;
        }
        return file2;
    }

    public static boolean deleteFiles(File root) {
        File[] fileArray = root.listFiles();
        if (fileArray != null) {
            for (File file : fileArray) {
                if (file.isDirectory() || !file.exists() || file.delete()) continue;
                return false;
            }
        }
        return true;
    }

    public static long getFileName(File file) {
        if (file != null) {
            return Long.parseLong(file.getName().replace(".txt", ""));
        }
        return 0L;
    }

    public static interface WriteProgress {
        public void writeProgress(int var1);

        public void error(Exception var1);
    }
}

