/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.core.utils;

import android.content.Context;
import android.text.TextUtils;
import com.alimm.tanx.core.ut.UtErrorCode;
import com.alimm.tanx.core.ut.impl.TanxBaseUt;
import com.alimm.tanx.core.utils.LogUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class FileUtils {
    public static final int DIR_TYPE_FILE = 0;
    public static final int DIR_TYPE_CACHE = 1;
    private static final String TAG = "FileUtils";
    private static final int COPY_BUFFER_SIZE = 4096;

    public static String joinPath(String ... parts) {
        StringBuilder stringBuilder = new StringBuilder();
        if (null != parts) {
            for (int i = 0; i < parts.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(File.separator);
                }
                stringBuilder.append(parts[i]);
            }
        }
        return stringBuilder.toString();
    }

    public static boolean exists(String path) {
        try {
            return !TextUtils.isEmpty((CharSequence)path) && new File(path).exists();
        }
        catch (SecurityException securityException) {
            LogUtils.d(TAG, "call exists failed.", securityException);
            return false;
        }
    }

    private static boolean ensureFileExists(String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return false;
        }
        File file = new File(filePath);
        if (!file.exists()) {
            try {
                File file2 = file.getParentFile();
                if (!file2.exists() && !file2.mkdirs()) {
                    return false;
                }
                if (!file.createNewFile()) {
                    return false;
                }
            }
            catch (IOException | SecurityException exception) {
                exception.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private static void closeIO(Closeable closeable) {
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readLines(String filePath) {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (FileUtils.exists(filePath)) {
            BufferedReader bufferedReader = null;
            try {
                String string;
                bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(filePath)));
                while ((string = bufferedReader.readLine()) != null) {
                    linkedList.add(string);
                }
                FileUtils.closeIO(bufferedReader);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                FileUtils.closeIO(bufferedReader);
            }
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeLine(String filePath, boolean append, String line) {
        if (!FileUtils.ensureFileExists(filePath)) {
            return;
        }
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new BufferedWriter(new FileWriter(filePath, append)));
            printWriter.println(line);
            FileUtils.closeIO(printWriter);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            FileUtils.closeIO(printWriter);
        }
    }

    public static void delete(String filePath) {
        if (!TextUtils.isEmpty((CharSequence)filePath)) {
            try {
                FileUtils.deleteFile(new File(filePath));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static synchronized boolean deleteFile(File file) {
        if (file == null) {
            return false;
        }
        if (file.exists()) {
            File[] fileArray;
            if (file.isFile()) {
                return file.delete();
            }
            if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
                for (int i = 0; i < fileArray.length; ++i) {
                    if (FileUtils.deleteFile(fileArray[i])) continue;
                    return false;
                }
            }
            return file.delete();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean saveStr2File(File file, String str) {
        if (file == null) {
            return false;
        }
        boolean bl = true;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(str.getBytes());
            fileOutputStream.close();
        }
        catch (Exception exception) {
            try {
                LogUtils.e(TAG, "saveStrToFile ", exception);
                TanxBaseUt.utError(UtErrorCode.CRASH_ERROR.getIntCode(), TAG, "saveStrToFile " + LogUtils.getStackTraceMessage(exception), "");
                bl = false;
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                FileUtils.closeIO(fileOutputStream);
                throw throwable;
            }
            FileUtils.closeIO(fileOutputStream);
        }
        FileUtils.closeIO(fileOutputStream);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean saveStr2File(String filePath, String str) {
        if (TextUtils.isEmpty((CharSequence)filePath) || TextUtils.isEmpty((CharSequence)str)) {
            return false;
        }
        boolean bl = true;
        FileOutputStream fileOutputStream = null;
        try {
            File file = new File(filePath);
            if (!file.exists()) {
                File file2 = new File(file.getParent());
                file2.mkdirs();
                file.createNewFile();
            }
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(str.getBytes());
            fileOutputStream.close();
        }
        catch (Exception exception) {
            try {
                LogUtils.e(TAG, "saveStrToFile ", exception);
                TanxBaseUt.utError(UtErrorCode.CRASH_ERROR.getIntCode(), TAG, "saveStrToFile " + LogUtils.getStackTraceMessage(exception), "");
                bl = false;
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                FileUtils.closeIO(fileOutputStream);
                throw throwable;
            }
            FileUtils.closeIO(fileOutputStream);
        }
        FileUtils.closeIO(fileOutputStream);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized String getStrFromFile(String filePath) {
        String string = "";
        FileInputStream fileInputStream = null;
        try {
            File file = new File(filePath);
            if (!file.exists()) {
                String string2 = null;
                return string2;
            }
            fileInputStream = new FileInputStream(filePath);
            int n = fileInputStream.available();
            byte[] byArray = new byte[n];
            fileInputStream.read(byArray);
            string = new String(byArray, "UTF-8");
            fileInputStream.close();
            FileUtils.closeIO(fileInputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            FileUtils.closeIO(fileInputStream);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized String getStrFromFile(File file) {
        StringBuilder stringBuilder = new StringBuilder();
        FileInputStream fileInputStream = null;
        try {
            if (!file.exists()) {
                String string = null;
                return string;
            }
            fileInputStream = new FileInputStream(file);
            if (fileInputStream != null) {
                String string;
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                while ((string = bufferedReader.readLine()) != null) {
                    stringBuilder.append(string);
                }
                bufferedReader.close();
                inputStreamReader.close();
            }
            FileUtils.closeIO(fileInputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            FileUtils.closeIO(fileInputStream);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readAssetFile(Context context, String fileName) {
        if (context == null || fileName == null) {
            return "";
        }
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new InputStreamReader(context.getResources().getAssets().open(fileName)));
            StringBuilder stringBuilder = new StringBuilder();
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string);
            }
            String string2 = stringBuilder.toString();
            FileUtils.closeIO(bufferedReader);
            return string2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            FileUtils.closeIO(bufferedReader);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean decompress(String inputFilePath, String outputDirPath) {
        boolean bl = true;
        ZipInputStream zipInputStream = null;
        try {
            ZipEntry zipEntry;
            File file = new File(outputDirPath);
            if (!file.exists()) {
                file.mkdirs();
            }
            zipInputStream = new ZipInputStream(new FileInputStream(new File(inputFilePath)));
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String string = FileUtils.joinPath(outputDirPath, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    FileUtils.mkdir(string);
                    continue;
                }
                bl &= FileUtils.copyTo(new File(string), zipInputStream);
            }
        }
        catch (Exception exception) {
            try {
                LogUtils.d(TAG, "decompress exception: inputFilePath = " + inputFilePath + ", outputDirPath = " + outputDirPath, exception);
                bl = false;
            }
            catch (Throwable throwable) {
                FileUtils.closeIO(zipInputStream);
                throw throwable;
            }
            FileUtils.closeIO(zipInputStream);
        }
        FileUtils.closeIO(zipInputStream);
        return bl;
    }

    public static File mkdir(String folderPath) {
        File file = null;
        if (!TextUtils.isEmpty((CharSequence)folderPath) && !(file = new File(folderPath)).exists()) {
            try {
                file.mkdirs();
            }
            catch (Exception exception) {
                LogUtils.d(TAG, "mkdir exception: folderPath = " + folderPath, exception);
            }
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean copyTo(File output, InputStream inputStream) {
        boolean bl;
        FileOutputStream fileOutputStream = null;
        try {
            int n;
            fileOutputStream = new FileOutputStream(output);
            byte[] byArray = new byte[4096];
            while ((n = inputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            bl = true;
        }
        catch (IOException iOException) {
            boolean bl2;
            try {
                LogUtils.d(TAG, "copyTo exception: output = " + output, iOException);
                bl2 = false;
            }
            catch (Throwable throwable) {
                FileUtils.closeIO(fileOutputStream);
                throw throwable;
            }
            FileUtils.closeIO(fileOutputStream);
            return bl2;
        }
        FileUtils.closeIO(fileOutputStream);
        return bl;
    }

    private static List<File> getFiles(String realPath, List<File> files) {
        File[] fileArray;
        File file = new File(realPath);
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            for (File file2 : fileArray) {
                if (file2.isDirectory()) {
                    FileUtils.getFiles(file2.getAbsolutePath(), files);
                }
                files.add(file2);
            }
        }
        return files;
    }

    public static List<File> getFiles(String realPath) {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (!TextUtils.isEmpty((CharSequence)realPath)) {
            FileUtils.getFiles(realPath, arrayList);
        }
        return arrayList;
    }

    public static void deleteExpiredFiles(String folderPath, int expireDays, FileKeepRule rule) {
        try {
            List<File> list = FileUtils.getFiles(folderPath);
            LogUtils.d(TAG, "deleteExpiredFiles: expireDays = " + expireDays);
            if (list != null && list.size() > 0) {
                for (File file : list) {
                    if (System.currentTimeMillis() - file.lastModified() <= TimeUnit.DAYS.toMillis(expireDays) || rule != null && rule.needKept(file.getName())) continue;
                    LogUtils.d(TAG, "deleteExpiredFile: file = " + file);
                    FileUtils.deleteFile(file);
                }
            }
        }
        catch (Exception exception) {
            LogUtils.e(TAG, "deleteExpiredFiles: exception.", exception);
            TanxBaseUt.utError(UtErrorCode.CRASH_ERROR.getIntCode(), TAG, "deleteExpiredFiles: exception." + LogUtils.getStackTraceMessage(exception), "");
        }
    }

    public static File getExternalDir(Context context, int type) {
        File file = null;
        try {
            if (type == 0) {
                file = context.getExternalFilesDir(null);
            } else if (type == 1) {
                file = context.getExternalCacheDir();
            }
        }
        catch (Throwable throwable) {
            LogUtils.d(TAG, "getExternalDir exception: type = " + type);
        }
        return file;
    }

    public static boolean unZipFolder(String zipFileString, String outPathString) throws Exception {
        ZipEntry zipEntry;
        if (!new File(zipFileString).exists()) {
            return false;
        }
        ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(zipFileString));
        String string = "";
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            int n;
            File file;
            string = zipEntry.getName();
            if (zipEntry.isDirectory()) {
                string = string.substring(0, string.length() - 1);
                file = new File(outPathString + File.separator + string);
                file.mkdirs();
                continue;
            }
            file = new File(outPathString + File.separator + string);
            file.createNewFile();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            byte[] byArray = new byte[1024];
            while ((n = zipInputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
                fileOutputStream.flush();
            }
            fileOutputStream.close();
        }
        zipInputStream.close();
        return true;
    }

    public static InputStream upZip(String zipFileString, String fileString) throws Exception {
        ZipFile zipFile = new ZipFile(zipFileString);
        ZipEntry zipEntry = zipFile.getEntry(fileString);
        return zipFile.getInputStream(zipEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(InputStream inStream, FileOutputStream fs) {
        boolean bl = false;
        try {
            int n = 0;
            byte[] byArray = new byte[1444];
            while ((n = inStream.read(byArray)) != -1) {
                fs.write(byArray, 0, n);
            }
            bl = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (fs != null) {
                    fs.close();
                }
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return bl;
    }

    public static interface FileKeepRule {
        public boolean needKept(String var1);
    }
}

