/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.core.utils;

import android.text.TextUtils;
import android.util.Log;
import com.alimm.tanx.core.SdkConstant;
import com.alimm.tanx.core.TanxCoreSdk;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;

public class LogUtils {
    private static final String LOG_TAG = "TanxAdSdk";
    private static String[] tagCloseSwitch = new String[]{"UtRequest", "TanxAdMonitor"};
    private static List<String> tagCloseSwitchList;

    public static boolean isDebug() {
        boolean bl = false;
        try {
            if (tagCloseSwitchList == null) {
                tagCloseSwitchList = Arrays.asList(tagCloseSwitch);
            }
            bl = TanxCoreSdk.getConfig().isDebugMode();
        }
        catch (Exception exception) {
            LogUtils.e(exception);
        }
        return bl;
    }

    public static boolean isDebugAndIsSwitch(String tag) {
        boolean bl = true;
        try {
            if (tagCloseSwitchList == null) {
                tagCloseSwitchList = Arrays.asList(tagCloseSwitch);
            }
            bl = !tagCloseSwitchList.contains(tag);
        }
        catch (Exception exception) {
            LogUtils.e(exception);
        }
        return LogUtils.isDebug() && bl;
    }

    public static void v(String subTag, String msg) {
        if (LogUtils.isDebugAndIsSwitch(subTag)) {
            LogUtils.startPrint(LOG_TAG, "[" + subTag + "] " + msg, "v");
        }
    }

    public static void d(String subTag, String msg) {
        if (LogUtils.isDebugAndIsSwitch(subTag)) {
            LogUtils.startPrint(LOG_TAG, "[" + subTag + "] " + msg, "d");
        }
    }

    public static void d(String subTag, String msg, Throwable tr) {
        if (LogUtils.isDebugAndIsSwitch(subTag)) {
            LogUtils.startPrint(LOG_TAG, "[" + subTag + "] " + msg + LogUtils.getStackTraceMessage(tr), "d");
        }
    }

    public static void i(String subTag, String msg) {
        if (LogUtils.isDebugAndIsSwitch(subTag)) {
            LogUtils.startPrint(LOG_TAG, "[" + subTag + "] " + msg, "i");
        }
    }

    public static void e(String subTag, String msg) {
        LogUtils.e(subTag, msg, "");
    }

    public static void e(String subTag, String msg, String task) {
        LogUtils.startPrint(LOG_TAG, "[" + subTag + "] " + msg, "e");
    }

    public static void e(Exception msg) {
        LogUtils.e("", msg);
    }

    public static void e(String tag, Exception msg) {
        LogUtils.e(tag, msg, "");
    }

    public static void e(String tag, Exception msg, String taskName) {
        LogUtils.startPrint(LOG_TAG, "[" + tag + "] " + LogUtils.getStackTraceMessage(msg), "e");
    }

    public static void e(String subTag, String msg, Throwable tr) {
        String string = msg + LogUtils.getStackTraceMessage(tr);
        LogUtils.startPrint(LOG_TAG, "[" + subTag + "] " + string, "e");
    }

    public static void d(String subTag, String ... args) {
        if (LogUtils.isDebugAndIsSwitch(subTag)) {
            LogUtils.startPrint(LOG_TAG, LogUtils.getLogString(subTag, args), "d");
        }
    }

    public static void i(String subTag, String ... args) {
        if (LogUtils.isDebugAndIsSwitch(subTag)) {
            LogUtils.startPrint(LOG_TAG, LogUtils.getLogString(subTag, args), "i");
        }
    }

    public static void w(String subTag, String ... args) {
        if (LogUtils.isDebugAndIsSwitch(subTag)) {
            LogUtils.startPrint(LOG_TAG, LogUtils.getLogString(subTag, args), "w");
        }
    }

    public static void d2print(String subTag, String msg) {
        LogUtils.startPrint(LOG_TAG, "[" + subTag + "] " + msg, "d");
    }

    private static String getLogString(String subTag, String ... args) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[").append(subTag).append("] ");
        for (String string : args) {
            if (TextUtils.isEmpty((CharSequence)string)) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String getStackTraceMessage(Throwable throwable) {
        if (null == throwable) {
            return "\u672c\u6b21throwable\u4e3anull";
        }
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter((Writer)stringWriter, true));
        String string = stringWriter.toString();
        return string;
    }

    public static void startPrint(String tag, String msg, String type) {
        msg = msg + " [SDK Version:" + SdkConstant.getSdkVersion() + "]";
        int n = 2001 - tag.length();
        switch (type) {
            case "e": {
                while (msg.length() > n) {
                    Log.e((String)tag, (String)msg.substring(0, n));
                    msg = msg.substring(n);
                }
                Log.e((String)tag, (String)msg);
                break;
            }
            case "d": {
                while (msg.length() > n) {
                    Log.d((String)tag, (String)msg.substring(0, n));
                    msg = msg.substring(n);
                }
                Log.d((String)tag, (String)msg);
                break;
            }
            case "i": {
                while (msg.length() > n) {
                    Log.i((String)tag, (String)msg.substring(0, n));
                    msg = msg.substring(n);
                }
                Log.i((String)tag, (String)msg);
                break;
            }
            case "w": {
                while (msg.length() > n) {
                    Log.w((String)tag, (String)msg.substring(0, n));
                    msg = msg.substring(n);
                }
                Log.w((String)tag, (String)msg);
                break;
            }
            case "v": {
                while (msg.length() > n) {
                    Log.v((String)tag, (String)msg.substring(0, n));
                    msg = msg.substring(n);
                }
                Log.v((String)tag, (String)msg);
            }
        }
    }
}

