/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.core.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;

public class MD5Utils {
    public static final String ALGORIGTHM_MD5 = "MD5";
    public static final String EMPTY_CONTENT_MD5 = "d41d8cd98f00b204e9800998ecf8427e";
    protected static char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static MessageDigest getMD5Digest() {
        try {
            return MessageDigest.getInstance(ALGORIGTHM_MD5);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static String getMD5String(String s) {
        if (s == null) {
            return "";
        }
        return MD5Utils.getMD5String(s.getBytes());
    }

    public static String getFileMD5String(File file) throws IOException {
        MessageDigest messageDigest = MD5Utils.getMD5Digest();
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[1024];
        int n = 0;
        while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
            messageDigest.update(byArray, 0, n);
        }
        ((InputStream)fileInputStream).close();
        return MD5Utils.bytesToHex(messageDigest.digest());
    }

    public static String getFilePathMD5String(String path) {
        try {
            byte[] byArray = new byte[8192];
            int n = 0;
            MessageDigest messageDigest = MessageDigest.getInstance(ALGORIGTHM_MD5);
            File file = new File(path);
            FileInputStream fileInputStream = new FileInputStream(file);
            while ((n = fileInputStream.read(byArray)) != -1) {
                messageDigest.update(byArray, 0, n);
            }
            fileInputStream.close();
            byte[] byArray2 = messageDigest.digest();
            BigInteger bigInteger = new BigInteger(1, byArray2);
            return bigInteger.toString(16);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "";
        }
    }

    public static String getMD5String(byte[] bytes) {
        MessageDigest messageDigest = MD5Utils.getMD5Digest();
        messageDigest.update(bytes);
        return MD5Utils.bytesToHex(messageDigest.digest());
    }

    public static String getMD5String(byte[] bytes, int offset, int length) {
        MessageDigest messageDigest = MD5Utils.getMD5Digest();
        messageDigest.update(bytes, offset, length);
        return MD5Utils.bytesToHex(messageDigest.digest());
    }

    public static String bytesToHex(byte[] bytes) {
        return MD5Utils.bytesToHex(bytes, 0, bytes.length);
    }

    public static String bytesToHex(byte[] bytes, int m, int n) {
        StringBuffer stringBuffer = new StringBuffer(2 * n);
        int n2 = m + n;
        for (int i = m; i < n2; ++i) {
            MD5Utils.appendHexPair(bytes[i], stringBuffer);
        }
        return stringBuffer.toString();
    }

    private static void appendHexPair(byte bt, StringBuffer stringbuffer) {
        char c = hexDigits[(bt & 0xF0) >> 4];
        char c2 = hexDigits[bt & 0xF];
        stringbuffer.append(c);
        stringbuffer.append(c2);
    }
}

