/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.core.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.telephony.TelephonyManager;
import com.alimm.tanx.core.net.constant.NetWorkType;
import com.alimm.tanx.core.ut.UtErrorCode;
import com.alimm.tanx.core.ut.impl.TanxBaseUt;
import com.alimm.tanx.core.utils.LogUtils;

public class NetWorkUtil {
    public static boolean isNetworkConnected(Context context) {
        ConnectivityManager connectivityManager;
        NetworkInfo networkInfo;
        if (context != null && (networkInfo = (connectivityManager = (ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo()) != null) {
            return networkInfo.isAvailable();
        }
        return false;
    }

    public static int getOperatorType(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        String string = telephonyManager.getSimOperatorName();
        if (string != null) {
            if (string.equals("46000") || string.equals("46002") || string.equals("46007")) {
                return 1;
            }
            if (string.equals("46001")) {
                return 2;
            }
            if (string.equals("46003")) {
                return 3;
            }
        } else {
            try {
                String string2 = telephonyManager.getSubscriberId();
                if (string2 != null) {
                    if (string2.startsWith("46000") || string2.startsWith("46002") || string2.startsWith("46007")) {
                        return 1;
                    }
                    if (string2.startsWith("46001")) {
                        return 2;
                    }
                    if (string2.startsWith("46003")) {
                        return 3;
                    }
                }
            }
            catch (Exception exception) {
                LogUtils.e(exception);
                TanxBaseUt.utError(UtErrorCode.CRASH_ERROR.getIntCode(), "NetWorkUtil", LogUtils.getStackTraceMessage(exception), "");
            }
        }
        return 0;
    }

    private NetWorkUtil() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    private static NetworkInfo getActiveNetworkInfo(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        return connectivityManager.getActiveNetworkInfo();
    }

    public static NetWorkType getNetworkType(Context context) {
        NetWorkType netWorkType = NetWorkType.NETWORK_NO;
        NetworkInfo networkInfo = NetWorkUtil.getActiveNetworkInfo(context);
        if (networkInfo != null && networkInfo.isAvailable()) {
            if (networkInfo.getType() == 1) {
                netWorkType = NetWorkType.NETWORK_WIFI;
            } else if (networkInfo.getType() == 0) {
                switch (networkInfo.getSubtype()) {
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: 
                    case 17: {
                        netWorkType = NetWorkType.NETWORK_3G;
                        break;
                    }
                    case 13: 
                    case 18: {
                        netWorkType = NetWorkType.NETWORK_4G;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: 
                    case 16: {
                        netWorkType = NetWorkType.NETWORK_2G;
                        break;
                    }
                    default: {
                        String string = networkInfo.getSubtypeName();
                        if (string.equalsIgnoreCase("TD-SCDMA") || string.equalsIgnoreCase("WCDMA") || string.equalsIgnoreCase("CDMA2000")) {
                            netWorkType = NetWorkType.NETWORK_3G;
                            break;
                        }
                        netWorkType = NetWorkType.NETWORK_UNKNOWN;
                        break;
                    }
                }
            } else {
                netWorkType = NetWorkType.NETWORK_UNKNOWN;
            }
        }
        return netWorkType;
    }
}

