/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.core.utils;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import com.alimm.tanx.core.TanxCoreSdk;
import com.alimm.tanx.core.utils.LogUtils;
import com.alimm.tanx.core.utils.ThreadUtils;

public class SharedPreferencesHelper {
    private static final String TAG = SharedPreferencesHelper.class.getSimpleName();
    private static SharedPreferencesHelper mInstance;
    private SharedPreferences mPrefs;
    public static final String KEY_SETTING = "KEY_SETTING";
    public static final String KEY_ORANGE = "KEY_ORANGE";
    public static final String REWARD_URL = "RewardUrl";
    public static final String KEY_ENCRYPT_SWITCH = "KEY_ENCRYPT_SWITCH";
    public static final String KEY_DEBUG_URL_SWITCH = "KEY_DEBUG_URL_SWITCH";
    public static final String KEY_HTTPS_SWITCH = "KEY_HTTPS_SWITCH";
    public static final String KEY_SPLASH_COVER = "KEY_SPLASH_COVER";
    public static final String KEY_SPLASH_COVER_W_RATIO = "key_splash_cover_w_ratio";
    public static final String KEY_SPLASH_COVER_H_RATIO = "key_splash_cover_h_ratio";
    public static final String KEY_SPLASH_COVER_TIME = "key_splash_cover_time";
    public static final String KEY_SPLASH_COVER_TIME_DURATION = "key_splash_cover_time_duration";
    public static final String KEY_SPLASH_AD_COUNT = "key_splash_ad_count";

    public static SharedPreferencesHelper getInstance() {
        return SharedPreferencesHelper.getInstance((Context)TanxCoreSdk.getApplication());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SharedPreferencesHelper getInstance(Context context) {
        if (mInstance != null) return mInstance;
        Class<SharedPreferencesHelper> clazz = SharedPreferencesHelper.class;
        synchronized (SharedPreferencesHelper.class) {
            if (mInstance != null) return mInstance;
            mInstance = new SharedPreferencesHelper(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    private SharedPreferencesHelper(Context context) {
        this.mPrefs = PreferenceManager.getDefaultSharedPreferences((Context)context);
    }

    public void putString(final String k, final String v) {
        ThreadUtils.executeByIo(new ThreadUtils.SimpleTask<Object>(){

            @Override
            public Object doInBackground() throws Throwable {
                SharedPreferences.Editor editor = SharedPreferencesHelper.this.mPrefs.edit();
                editor.putString(k, v);
                editor.apply();
                return null;
            }

            @Override
            public void onSuccess(Object result) {
            }
        });
    }

    public String getString(String k) {
        return this.mPrefs.getString(k, "");
    }

    public void putFloat(final String k, final float v) {
        ThreadUtils.executeByIo(new ThreadUtils.SimpleTask<Object>(){

            @Override
            public Object doInBackground() throws Throwable {
                SharedPreferences.Editor editor = SharedPreferencesHelper.this.mPrefs.edit();
                editor.putFloat(k, v);
                editor.apply();
                return null;
            }

            @Override
            public void onSuccess(Object result) {
            }
        });
    }

    public int getInt(String k) {
        return this.mPrefs.getInt(k, 0);
    }

    public int getInt(String k, int defaultValue) {
        return this.mPrefs.getInt(k, defaultValue);
    }

    public void putInt(final String k, final Integer v) {
        ThreadUtils.executeByIo(new ThreadUtils.SimpleTask<Object>(){

            @Override
            public Object doInBackground() throws Throwable {
                SharedPreferences.Editor editor = SharedPreferencesHelper.this.mPrefs.edit();
                editor.putInt(k, v.intValue());
                editor.apply();
                return null;
            }

            @Override
            public void onSuccess(Object result) {
            }
        });
    }

    public float getFloat(String k) {
        return this.mPrefs.getFloat(k, 0.0f);
    }

    public void putDebugUrlBoolean(final boolean v) {
        ThreadUtils.executeByIo(new ThreadUtils.SimpleTask<Object>(){

            @Override
            public Object doInBackground() throws Throwable {
                SharedPreferences.Editor editor = SharedPreferencesHelper.this.mPrefs.edit();
                editor.putBoolean(SharedPreferencesHelper.KEY_DEBUG_URL_SWITCH, v);
                editor.apply();
                return null;
            }

            @Override
            public void onSuccess(Object result) {
            }
        });
    }

    public boolean getDebugUrlBoolean() {
        boolean bl = this.mPrefs.getBoolean(KEY_DEBUG_URL_SWITCH, false);
        LogUtils.d2print(TAG, "now deBugUrl Switch ->" + bl);
        return bl;
    }

    public void putEncryptBoolean(boolean v) {
        this.putBoolean(KEY_ENCRYPT_SWITCH, v);
    }

    public boolean getEncryptBoolean() {
        boolean bl = this.getBoolean(KEY_ENCRYPT_SWITCH, true);
        LogUtils.d(TAG, "now encryptSwitch ->" + bl);
        return bl;
    }

    public void putHttpsBoolean(boolean v) {
        this.putBoolean(KEY_HTTPS_SWITCH, v);
    }

    public boolean getHttpsBoolean() {
        boolean bl = this.getBoolean(KEY_HTTPS_SWITCH, false);
        LogUtils.d2print(TAG, "now httpsSwitch ->" + bl);
        return bl;
    }

    public boolean getBoolean(String key, Boolean defaultB) {
        boolean bl = this.mPrefs.getBoolean(key, defaultB.booleanValue());
        return bl;
    }

    public void putBoolean(final String key, final Boolean v) {
        ThreadUtils.executeByIo(new ThreadUtils.SimpleTask<Object>(){

            @Override
            public Object doInBackground() throws Throwable {
                SharedPreferences.Editor editor = SharedPreferencesHelper.this.mPrefs.edit();
                editor.putBoolean(key, v.booleanValue());
                editor.apply();
                return null;
            }

            @Override
            public void onSuccess(Object result) {
            }
        });
    }

    public void switchSplashCover(boolean open) {
        SharedPreferences.Editor editor = this.mPrefs.edit();
        editor.putBoolean(KEY_SPLASH_COVER, open);
        editor.apply();
    }

    public boolean isOpenSplashCover() {
        return this.mPrefs.getBoolean(KEY_SPLASH_COVER, false);
    }
}

