/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.core.utils;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.alimm.tanx.core.R;
import com.alimm.tanx.core.TanxCoreSdk;
import com.alimm.tanx.core.orange.OrangeManager;
import com.alimm.tanx.core.utils.LogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SysUtils {
    private static final String TAG = "SysUtils";

    public static long currentTimeSecs() {
        return System.currentTimeMillis() / 1000L;
    }

    public static int getScreenWidth(Context context) {
        return context.getResources().getDisplayMetrics().widthPixels;
    }

    public static int getScreenHeight(Context context) {
        return context.getResources().getDisplayMetrics().heightPixels;
    }

    public static int getStatusBarHeight(Context context) {
        int n;
        try {
            int n2 = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
            if (n2 <= 0) {
                n2 = R.dimen.default_status_bar_height;
            }
            n = context.getResources().getDimensionPixelSize(n2);
            Log.v((String)TAG, (String)("System StatusBar height : " + n));
        }
        catch (Exception exception) {
            n = context.getResources().getDimensionPixelSize(R.dimen.default_status_bar_height);
            Log.e((String)TAG, (String)"getStatusBarHeight() failed:", (Throwable)exception);
        }
        return n;
    }

    public static List<String> getInstallStatus() {
        ArrayList<String> arrayList = new ArrayList<String>();
        HashMap<String, Boolean> hashMap = OrangeManager.getInstance().getInstallSwitch();
        if (OrangeManager.getInstance().getInstallSwitch() != null) {
            for (Map.Entry<String, Boolean> entry : hashMap.entrySet()) {
                if (entry.getValue() == null || !entry.getValue().booleanValue() || TextUtils.isEmpty((CharSequence)entry.getKey()) || !SysUtils.hasPackage((Context)TanxCoreSdk.getApplication(), entry.getKey())) continue;
                arrayList.add(entry.getKey());
            }
        }
        return arrayList;
    }

    private static boolean hasPackage(Context context, String pkgName) {
        if (null == context || null == pkgName) {
            return false;
        }
        boolean bl = true;
        try {
            context.getPackageManager().getPackageInfo(pkgName, 256);
        }
        catch (Exception exception) {
            LogUtils.e("hasPackage", exception);
            bl = false;
        }
        return bl;
    }

    public static int getStatusbarHeight(Context context) {
        int n = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (n > 0) {
            return context.getResources().getDimensionPixelSize(n);
        }
        return 0;
    }

    public static int getStatusBarHeight2WebView(Context context) {
        int n = SysUtils.getStatusbarHeight(context);
        int n2 = 0;
        if (n > 0) {
            n2 = n - 58;
        }
        if (n2 <= 0) {
            return 0;
        }
        return n2;
    }
}

