/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.core.utils;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.alimm.tanx.core.R;
import com.alimm.tanx.core.TanxCoreSdk;
import com.alimm.tanx.core.utils.SysUtils;

public class ToastUtil {
    private static Toast mToast;
    public static int SHORT_TIME;
    public static int LONG_TIME;

    public static void showShortToast(String content) {
        ToastUtil.showShortToast((Context)TanxCoreSdk.getApplication(), content);
    }

    public static Toast showShortToast(Context c, String content) {
        return ToastUtil.showToast(c, content, SHORT_TIME);
    }

    public static Toast showLongToast(Context c, String content) {
        return ToastUtil.showToast(c, content, LONG_TIME);
    }

    public static Toast showToast(Context c, String content, int duration) {
        if (TextUtils.isEmpty((CharSequence)content)) {
            return null;
        }
        if (c == null) {
            return null;
        }
        Context context = c.getApplicationContext();
        mToast = new Toast(context);
        LayoutInflater layoutInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        View view = layoutInflater.inflate(R.layout.layout_commont_toast, null);
        mToast.setView(view);
        mToast.setGravity(80, 0, SysUtils.getScreenHeight(c) / 2);
        mToast.setDuration(duration);
        TextView textView = (TextView)view.findViewById(R.id.tv_toast);
        textView.setText((CharSequence)content);
        mToast.show();
        return mToast;
    }

    public static Toast showToastImg(String content, int imgRes) {
        return ToastUtil.showToastImg((Context)TanxCoreSdk.getApplication(), content, LONG_TIME, imgRes);
    }

    public static Toast showToastImg(Context c, String content, int duration, int imgRes) {
        if (TextUtils.isEmpty((CharSequence)content)) {
            return null;
        }
        if (c == null) {
            return null;
        }
        Context context = c.getApplicationContext();
        mToast = new Toast(context);
        LayoutInflater layoutInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        View view = layoutInflater.inflate(R.layout.layout_commont_toast_img, null);
        mToast.setView(view);
        mToast.setGravity(80, 0, SysUtils.getScreenHeight(c) / 2);
        mToast.setDuration(duration);
        TextView textView = (TextView)view.findViewById(R.id.tv_toast);
        ImageView imageView = (ImageView)view.findViewById(R.id.iv_img);
        imageView.setImageResource(imgRes);
        textView.setText((CharSequence)content);
        mToast.show();
        return mToast;
    }

    static {
        SHORT_TIME = 2000;
        LONG_TIME = 3500;
    }
}

