/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.core.utils;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;

public final class UIThreadUtils {
    private UIThreadUtils() {
    }

    public static void run(@NonNull Runnable runnable) {
        if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
            runnable.run();
        } else {
            HandlerHolder.handler.post(runnable);
        }
    }

    public static void post(@NonNull Runnable runnable) {
        HandlerHolder.handler.post(runnable);
    }

    public static void postDelayed(@NonNull Runnable runnable, long ms) {
        HandlerHolder.handler.postDelayed(runnable, ms);
    }

    public static void removeCallbacks(@NonNull Runnable runnable) {
        HandlerHolder.handler.removeCallbacks(runnable);
    }

    private static final class HandlerHolder {
        private static final Handler handler = new Handler(Looper.getMainLooper());

        private HandlerHolder() {
        }
    }
}

