/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.core.web;

import android.content.Context;
import com.alimm.tanx.core.utils.LogUtils;
import com.alimm.tanx.core.web.cache.ResourceInterceptor;
import com.alimm.tanx.core.web.cache.WebViewCacheInterceptor;
import com.alimm.tanx.core.web.cache.WebViewCacheInterceptorInst;
import com.alimm.tanx.core.web.cache.config.CacheExtensionConfig;
import com.alimm.tanx.core.web.webview.AdWebView;
import com.alimm.tanx.core.web.webview.PreloadWebView;
import java.io.File;

public class WebCacheManager {
    private static WebCacheManager instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WebCacheManager getInstance() {
        if (null != instance) return instance;
        Class<WebCacheManager> clazz = WebCacheManager.class;
        synchronized (WebCacheManager.class) {
            if (null != instance) return instance;
            instance = new WebCacheManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void init(Context context) {
        this.preload();
        this.initWebViewCache(context);
    }

    private void initWebViewCache(Context context) {
        WebViewCacheInterceptor.Builder builder = new WebViewCacheInterceptor.Builder(context);
        builder.setCachePath(new File(context.getCacheDir(), "cache_path_name")).setDynamicCachePath(new File(context.getCacheDir(), "dynamic_webview_cache")).setCacheSize(0x3200000L).setConnectTimeoutSecond(20L).setReadTimeoutSecond(20L);
        CacheExtensionConfig cacheExtensionConfig = new CacheExtensionConfig();
        cacheExtensionConfig.addExtension("json").removeExtension("swf");
        builder.setCacheExtensionConfig(cacheExtensionConfig);
        builder.setDebug(LogUtils.isDebug());
        builder.setResourceInterceptor(new ResourceInterceptor(){

            @Override
            public boolean interceptor(String url) {
                return true;
            }
        });
        WebViewCacheInterceptorInst.getInstance().init(builder);
    }

    public AdWebView getAdWebView() {
        return new AdWebView();
    }

    private void preload() {
        PreloadWebView.getInstance().preload();
    }

    public void destroy() {
        PreloadWebView.getInstance().destroy();
    }
}

