/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.core.web.cache;

import android.content.Context;
import android.text.TextUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.concurrent.CopyOnWriteArraySet;

class AssetsLoader {
    private static volatile AssetsLoader assetsLoader;
    private Context mContext;
    private CopyOnWriteArraySet<String> mAssetResSet;
    private String mDir = "";
    private boolean mCleared = false;
    private boolean mIsSuffixMod = false;

    AssetsLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AssetsLoader getInstance() {
        if (assetsLoader != null) return assetsLoader;
        Class<AssetsLoader> clazz = AssetsLoader.class;
        synchronized (AssetsLoader.class) {
            if (assetsLoader != null) return assetsLoader;
            assetsLoader = new AssetsLoader();
            // ** MonitorExit[var0] (shouldn't be in output)
            return assetsLoader;
        }
    }

    public AssetsLoader isAssetsSuffixMod(boolean suffixMod) {
        this.mIsSuffixMod = suffixMod;
        return this;
    }

    public AssetsLoader init(Context context) {
        this.mContext = context;
        this.mAssetResSet = new CopyOnWriteArraySet();
        this.mCleared = false;
        return this;
    }

    private String getUrlPath(String url) {
        String string = "";
        try {
            URL uRL = new URL(url);
            string = uRL.getPath();
            if (string.startsWith("/")) {
                if (string.length() == 1) {
                    return string;
                }
                string = string.substring(1);
            }
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        return string;
    }

    public InputStream getResByUrl(String url) {
        String string = this.getUrlPath(url);
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        if (!this.mIsSuffixMod) {
            if (TextUtils.isEmpty((CharSequence)this.mDir)) {
                return this.getAssetFileStream(string);
            }
            return this.getAssetFileStream(this.mDir + File.separator + string);
        }
        if (this.mAssetResSet != null) {
            for (String string2 : this.mAssetResSet) {
                if (!string.endsWith(string2)) continue;
                if (TextUtils.isEmpty((CharSequence)this.mDir)) {
                    return this.getAssetFileStream(string2);
                }
                return this.getAssetFileStream(this.mDir + File.separator + string2);
            }
        }
        return null;
    }

    public AssetsLoader setDir(String dir) {
        this.mDir = dir;
        return this;
    }

    public AssetsLoader initData() {
        if (!this.mIsSuffixMod) {
            return this;
        }
        if (this.mAssetResSet.size() == 0) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    AssetsLoader.this.initResourceNoneRecursion(AssetsLoader.this.mDir);
                }
            }).start();
        }
        return this;
    }

    public void clear() {
        this.mCleared = true;
        if (this.mAssetResSet != null && this.mAssetResSet.size() > 0) {
            this.mAssetResSet.clear();
        }
    }

    private void addAssetsFile(String file) {
        int n;
        String string = this.mDir + File.separator;
        if (!TextUtils.isEmpty((CharSequence)this.mDir) && (n = file.indexOf(string)) >= 0) {
            file = file.substring(n + string.length());
        }
        this.mAssetResSet.add(file);
    }

    private AssetsLoader initResourceNoneRecursion(String dir) {
        try {
            String[] stringArray;
            LinkedList<String> linkedList = new LinkedList<String>();
            for (String string : stringArray = this.mContext.getAssets().list(dir)) {
                String string2 = dir + File.separator + string;
                String[] stringArray2 = this.mContext.getAssets().list(string2);
                if (stringArray2.length == 0) {
                    this.addAssetsFile(string2);
                    continue;
                }
                linkedList.add(string2);
            }
            while (!linkedList.isEmpty() && !this.mCleared) {
                String string = (String)linkedList.removeFirst();
                String[] stringArray3 = this.mContext.getAssets().list(string);
                if (stringArray3.length == 0) {
                    this.addAssetsFile(string);
                    continue;
                }
                for (String string3 : stringArray3) {
                    String[] stringArray4 = this.mContext.getAssets().list(string + File.separator + string3);
                    if (stringArray4.length == 0) {
                        this.addAssetsFile(string + File.separator + string3);
                        continue;
                    }
                    linkedList.add(string + File.separator + string3);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    public InputStream getAssetFileStream(String path) {
        try {
            return this.mContext.getAssets().open(path);
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

