/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.core.web.cache;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.webkit.URLUtil;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import com.alimm.tanx.core.utils.LogUtils;
import com.alimm.tanx.core.web.cache.AssetsLoader;
import com.alimm.tanx.core.web.cache.CacheType;
import com.alimm.tanx.core.web.cache.DynamicCacheLoader;
import com.alimm.tanx.core.web.cache.HttpCacheInterceptor;
import com.alimm.tanx.core.web.cache.ResourceInterceptor;
import com.alimm.tanx.core.web.cache.WebViewRequestInterceptor;
import com.alimm.tanx.core.web.cache.config.CacheExtensionConfig;
import com.alimm.tanx.core.web.cache.utils.FileUtil;
import com.alimm.tanx.core.web.cache.utils.MimeTypeMapUtils;
import com.alimm.tanx.core.web.cache.utils.NetUtils;
import com.alimm.tanx.core.web.cache.utils.OKHttpFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Cache;
import okhttp3.CacheControl;
import okhttp3.Dns;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class WebViewCacheInterceptor
implements WebViewRequestInterceptor {
    private final String TAG = "WebViewCacheInterceptor";
    private File mCacheFile;
    private File mDynamicCacheFile;
    private long mCacheSize;
    private long mConnectTimeout;
    private long mReadTimeout;
    private CacheExtensionConfig mCacheExtensionConfig;
    private Context mContext;
    private boolean mDebug;
    private CacheType mCacheType;
    private String mAssetsDir = null;
    private boolean mTrustAllHostname = false;
    private SSLSocketFactory mSSLSocketFactory = null;
    private X509TrustManager mX509TrustManager = null;
    private Dns mDns = null;
    private ResourceInterceptor mResourceInterceptor;
    private boolean mIsSuffixMod = false;
    private OkHttpClient mHttpClient = null;
    private String mOrigin = "";
    private String mReferer = "";
    private String mUserAgent = "";
    public static final String KEY_CACHE = "WebResourceInterceptor-Key-Cache";

    public WebViewCacheInterceptor(Builder builder) {
        this.mCacheExtensionConfig = builder.mCacheExtensionConfig;
        this.mCacheFile = builder.mCacheFile;
        this.mDynamicCacheFile = builder.mDynamicCacheFile;
        this.mCacheSize = builder.mCacheSize;
        this.mCacheType = builder.mCacheType;
        this.mConnectTimeout = builder.mConnectTimeout;
        this.mReadTimeout = builder.mReadTimeout;
        this.mContext = builder.mContext;
        this.mDebug = builder.mDebug;
        this.mAssetsDir = builder.mAssetsDir;
        this.mX509TrustManager = builder.mX509TrustManager;
        this.mSSLSocketFactory = builder.mSSLSocketFactory;
        this.mTrustAllHostname = builder.mTrustAllHostname;
        this.mResourceInterceptor = builder.mResourceInterceptor;
        this.mIsSuffixMod = builder.mIsSuffixMod;
        this.mDns = builder.mDns;
        this.initHttpClient();
        if (this.isEnableAssets()) {
            this.initAssetsLoader();
        }
    }

    private boolean isEnableDynamicCache() {
        return this.mDynamicCacheFile != null;
    }

    private boolean isEnableAssets() {
        return this.mAssetsDir != null;
    }

    private void initAssetsLoader() {
        AssetsLoader.getInstance().init(this.mContext).setDir(this.mAssetsDir).isAssetsSuffixMod(this.mIsSuffixMod);
    }

    private void initHttpClient() {
        Cache cache = new Cache(this.mCacheFile, this.mCacheSize);
        OkHttpClient.Builder builder = new OkHttpClient.Builder().cache(cache).connectTimeout(this.mConnectTimeout, TimeUnit.SECONDS).readTimeout(this.mReadTimeout, TimeUnit.SECONDS).addNetworkInterceptor((Interceptor)new HttpCacheInterceptor());
        if (this.mTrustAllHostname) {
            builder.hostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
        }
        if (this.mSSLSocketFactory != null && this.mX509TrustManager != null) {
            builder.sslSocketFactory(this.mSSLSocketFactory, this.mX509TrustManager);
        }
        if (this.mDns != null) {
            builder.dns(this.mDns);
        }
        this.mHttpClient = builder.build();
    }

    @Override
    @TargetApi(value=21)
    public WebResourceResponse interceptRequest(WebResourceRequest request) {
        return this.interceptRequest(request.getUrl().toString(), request.getRequestHeaders());
    }

    private Map<String, String> buildHeaders() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (!TextUtils.isEmpty((CharSequence)this.mOrigin)) {
            hashMap.put("Origin", this.mOrigin);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mReferer)) {
            hashMap.put("Referer", this.mReferer);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mUserAgent)) {
            hashMap.put("User-Agent", this.mUserAgent);
        }
        return hashMap;
    }

    @Override
    public WebResourceResponse interceptRequest(String url) {
        return this.interceptRequest(url, this.buildHeaders());
    }

    private boolean checkUrl(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return false;
        }
        if (!url.startsWith("http")) {
            return false;
        }
        if (this.mResourceInterceptor != null && !this.mResourceInterceptor.interceptor(url)) {
            return false;
        }
        String string = MimeTypeMapUtils.getFileExtensionFromUrl(url);
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        if (this.mCacheExtensionConfig.isMedia(string)) {
            return false;
        }
        return this.mCacheExtensionConfig.canCache(string);
    }

    @Override
    public void loadUrl(WebView webView, String url) {
        if (!this.isValidUrl(url)) {
            return;
        }
        webView.loadUrl(url);
        this.mReferer = webView.getUrl();
        this.mOrigin = NetUtils.getOriginUrl(this.mReferer);
        this.mUserAgent = webView.getSettings().getUserAgentString();
    }

    @Override
    public void loadUrl(String url, String userAgent) {
        if (!this.isValidUrl(url)) {
            return;
        }
        this.mReferer = url;
        this.mOrigin = NetUtils.getOriginUrl(this.mReferer);
        this.mUserAgent = userAgent;
    }

    @Override
    public void loadUrl(String url, Map<String, String> additionalHttpHeaders, String userAgent) {
        if (!this.isValidUrl(url)) {
            return;
        }
        this.mReferer = url;
        this.mOrigin = NetUtils.getOriginUrl(this.mReferer);
        this.mUserAgent = userAgent;
    }

    @Override
    public void loadUrl(WebView webView, String url, Map<String, String> additionalHttpHeaders) {
        if (!this.isValidUrl(url)) {
            return;
        }
        webView.loadUrl(url, additionalHttpHeaders);
        this.mReferer = webView.getUrl();
        this.mOrigin = NetUtils.getOriginUrl(this.mReferer);
        this.mUserAgent = webView.getSettings().getUserAgentString();
    }

    @Override
    public void clearCache() {
        FileUtil.deleteDirs(this.mCacheFile.getAbsolutePath(), false);
        AssetsLoader.getInstance().clear();
    }

    @Override
    public void enableForce(boolean force) {
        this.mCacheType = force ? CacheType.FORCE : CacheType.NORMAL;
    }

    @Override
    public InputStream getCacheFile(String url) {
        return OKHttpFile.getCacheFile(this.mCacheFile, url);
    }

    @Override
    public void initAssetsData() {
        AssetsLoader.getInstance().initData();
    }

    @Override
    public File getCachePath() {
        return this.mCacheFile;
    }

    public void addHeader(Request.Builder reqBuilder, Map<String, String> headers) {
        if (headers == null) {
            return;
        }
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            reqBuilder.addHeader(entry.getKey(), entry.getValue());
        }
    }

    private WebResourceResponse interceptRequest(String url, Map<String, String> headers) {
        Object object;
        if (this.mCacheType == CacheType.NORMAL) {
            return null;
        }
        if (!this.checkUrl(url)) {
            return null;
        }
        if (this.isEnableDynamicCache() && (object = DynamicCacheLoader.getInstance().getResByUrl(this.mDynamicCacheFile, url)) != null) {
            LogUtils.d("WebViewCacheInterceptor", String.format("from dynamic file: %s", url));
            String string = MimeTypeMapUtils.getMimeTypeFromUrl(url);
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream((File)object);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            WebResourceResponse webResourceResponse = new WebResourceResponse(string, "", (InputStream)fileInputStream);
            return webResourceResponse;
        }
        if (this.isEnableAssets() && (object = AssetsLoader.getInstance().getResByUrl(url)) != null) {
            LogUtils.d("WebViewCacheInterceptor", String.format("from assets: %s", url));
            String string = MimeTypeMapUtils.getMimeTypeFromUrl(url);
            WebResourceResponse webResourceResponse = new WebResourceResponse(string, "", (InputStream)object);
            return webResourceResponse;
        }
        try {
            Request request;
            Response response;
            Response response2;
            object = new Request.Builder().url(url);
            String string = MimeTypeMapUtils.getFileExtensionFromUrl(url);
            if (this.mCacheExtensionConfig.isHtml(string)) {
                headers.put(KEY_CACHE, this.mCacheType.ordinal() + "");
            }
            this.addHeader((Request.Builder)object, headers);
            if (!NetUtils.isConnected(this.mContext)) {
                object.cacheControl(CacheControl.FORCE_CACHE);
            }
            if ((response2 = (response = this.mHttpClient.newCall(request = object.build()).execute()).cacheResponse()) != null) {
                LogUtils.d("WebViewCacheInterceptor", String.format("from cache: %s", url));
            } else {
                LogUtils.d("WebViewCacheInterceptor", String.format("from server: %s", url));
            }
            String string2 = MimeTypeMapUtils.getMimeTypeFromUrl(url);
            WebResourceResponse webResourceResponse = new WebResourceResponse(string2, "", response.body().byteStream());
            if (response.code() == 504 && !NetUtils.isConnected(this.mContext)) {
                return null;
            }
            if (Build.VERSION.SDK_INT >= 21) {
                String string3 = response.message();
                if (TextUtils.isEmpty((CharSequence)string3)) {
                    string3 = "OK";
                }
                try {
                    webResourceResponse.setStatusCodeAndReasonPhrase(response.code(), string3);
                }
                catch (Exception exception) {
                    return null;
                }
                webResourceResponse.setResponseHeaders(NetUtils.multimapToSingle(response.headers().toMultimap()));
            }
            return webResourceResponse;
        }
        catch (Exception exception) {
            LogUtils.e("WebViewCacheInterceptor", exception);
            return null;
        }
    }

    boolean isValidUrl(String url) {
        return URLUtil.isValidUrl((String)url);
    }

    public static class Builder {
        private File mCacheFile;
        private File mDynamicCacheFile;
        private long mCacheSize = 0x6400000L;
        private long mConnectTimeout = 20L;
        private long mReadTimeout = 20L;
        private CacheExtensionConfig mCacheExtensionConfig;
        private Context mContext;
        private boolean mDebug = true;
        private CacheType mCacheType = CacheType.FORCE;
        private boolean mTrustAllHostname = false;
        private SSLSocketFactory mSSLSocketFactory = null;
        private X509TrustManager mX509TrustManager = null;
        private ResourceInterceptor mResourceInterceptor;
        private String mAssetsDir = null;
        private boolean mIsSuffixMod = false;
        private Dns mDns = null;

        public Builder(Context context) {
            this.mContext = context;
            this.mCacheFile = new File(context.getCacheDir().toString(), "CacheWebViewCache");
            this.mCacheExtensionConfig = new CacheExtensionConfig();
        }

        public void setResourceInterceptor(ResourceInterceptor resourceInterceptor) {
            this.mResourceInterceptor = resourceInterceptor;
        }

        public Builder setTrustAllHostname() {
            this.mTrustAllHostname = true;
            return this;
        }

        public Builder setSSLSocketFactory(SSLSocketFactory sslSocketFactory, X509TrustManager trustManager) {
            if (sslSocketFactory != null && trustManager != null) {
                this.mSSLSocketFactory = sslSocketFactory;
                this.mX509TrustManager = trustManager;
            }
            return this;
        }

        public Builder setCachePath(File file) {
            if (file != null) {
                this.mCacheFile = file;
            }
            return this;
        }

        public Builder setDynamicCachePath(File file) {
            if (file != null) {
                this.mDynamicCacheFile = file;
            }
            return this;
        }

        public Builder setCacheSize(long cacheSize) {
            if (cacheSize > 1024L) {
                this.mCacheSize = cacheSize;
            }
            return this;
        }

        public Builder setReadTimeoutSecond(long time) {
            if (time >= 0L) {
                this.mReadTimeout = time;
            }
            return this;
        }

        public Builder setConnectTimeoutSecond(long time) {
            if (time >= 0L) {
                this.mConnectTimeout = time;
            }
            return this;
        }

        public Builder setCacheExtensionConfig(CacheExtensionConfig config) {
            if (config != null) {
                this.mCacheExtensionConfig = config;
            }
            return this;
        }

        public Builder setDebug(boolean debug) {
            this.mDebug = debug;
            return this;
        }

        public Builder setCacheType(CacheType cacheType) {
            this.mCacheType = cacheType;
            return this;
        }

        public Builder isAssetsSuffixMod(boolean suffixMod) {
            this.mIsSuffixMod = suffixMod;
            return this;
        }

        public Builder setAssetsDir(String dir) {
            if (dir != null) {
                this.mAssetsDir = dir;
            }
            return this;
        }

        public void setDns(Dns dns) {
            this.mDns = dns;
        }

        public WebViewRequestInterceptor build() {
            return new WebViewCacheInterceptor(this);
        }
    }
}

