/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.core.web.cache;

import android.annotation.TargetApi;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import com.alimm.tanx.core.web.cache.AssetsLoader;
import com.alimm.tanx.core.web.cache.WebViewCacheInterceptor;
import com.alimm.tanx.core.web.cache.WebViewRequestInterceptor;
import java.io.File;
import java.io.InputStream;
import java.util.Map;

public class WebViewCacheInterceptorInst
implements WebViewRequestInterceptor {
    private static volatile WebViewCacheInterceptorInst webViewCacheInterceptorInst;
    private WebViewRequestInterceptor mInterceptor;

    public void init(WebViewCacheInterceptor.Builder builder) {
        if (builder != null) {
            this.mInterceptor = builder.build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WebViewCacheInterceptorInst getInstance() {
        if (webViewCacheInterceptorInst != null) return webViewCacheInterceptorInst;
        Class<WebViewCacheInterceptorInst> clazz = WebViewCacheInterceptorInst.class;
        synchronized (WebViewCacheInterceptorInst.class) {
            if (webViewCacheInterceptorInst != null) return webViewCacheInterceptorInst;
            webViewCacheInterceptorInst = new WebViewCacheInterceptorInst();
            // ** MonitorExit[var0] (shouldn't be in output)
            return webViewCacheInterceptorInst;
        }
    }

    @Override
    @TargetApi(value=21)
    public WebResourceResponse interceptRequest(WebResourceRequest request) {
        if (this.mInterceptor == null) {
            return null;
        }
        return this.mInterceptor.interceptRequest(request);
    }

    @Override
    public WebResourceResponse interceptRequest(String url) {
        if (this.mInterceptor == null) {
            return null;
        }
        return this.mInterceptor.interceptRequest(url);
    }

    @Override
    public void loadUrl(WebView webView, String url) {
        if (this.mInterceptor == null) {
            return;
        }
        this.mInterceptor.loadUrl(webView, url);
    }

    @Override
    public void loadUrl(String url, String userAgent) {
        if (this.mInterceptor == null) {
            return;
        }
        this.mInterceptor.loadUrl(url, userAgent);
    }

    @Override
    public void loadUrl(String url, Map<String, String> additionalHttpHeaders, String userAgent) {
        if (this.mInterceptor == null) {
            return;
        }
        this.mInterceptor.loadUrl(url, additionalHttpHeaders, userAgent);
    }

    @Override
    public void loadUrl(WebView webView, String url, Map<String, String> additionalHttpHeaders) {
        if (this.mInterceptor == null) {
            return;
        }
        this.mInterceptor.loadUrl(webView, url, additionalHttpHeaders);
    }

    @Override
    public void clearCache() {
        if (this.mInterceptor == null) {
            return;
        }
        this.mInterceptor.clearCache();
    }

    @Override
    public void enableForce(boolean force) {
        if (this.mInterceptor == null) {
            return;
        }
        this.mInterceptor.enableForce(force);
    }

    @Override
    public InputStream getCacheFile(String url) {
        if (this.mInterceptor == null) {
            return null;
        }
        return this.mInterceptor.getCacheFile(url);
    }

    @Override
    public void initAssetsData() {
        AssetsLoader.getInstance().initData();
    }

    @Override
    public File getCachePath() {
        if (this.mInterceptor == null) {
            return null;
        }
        return this.mInterceptor.getCachePath();
    }
}

