/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.core.web.cache.config;

import android.text.TextUtils;
import java.util.HashSet;

public class CacheExtensionConfig {
    private static HashSet STATIC = new HashSet(){
        {
            this.add("js");
            this.add("ico");
            this.add("css");
            this.add("png");
            this.add("jpg");
            this.add("jpeg");
            this.add("gif");
            this.add("bmp");
            this.add("ttf");
            this.add("woff");
            this.add("woff2");
            this.add("otf");
            this.add("eot");
            this.add("svg");
            this.add("xml");
            this.add("swf");
            this.add("txt");
            this.add("text");
            this.add("conf");
            this.add("webp");
        }
    };
    private static HashSet NO_CACH = new HashSet(){
        {
            this.add("mp4");
            this.add("mp3");
            this.add("ogg");
            this.add("avi");
            this.add("wmv");
            this.add("flv");
            this.add("rmvb");
            this.add("3gp");
        }
    };
    private HashSet statics = new HashSet(STATIC);
    private HashSet no_cache = new HashSet(NO_CACH);

    public static void addGlobalExtension(String extension) {
        CacheExtensionConfig.add(STATIC, extension);
    }

    public static void removeGlobalExtension(String extension) {
        CacheExtensionConfig.remove(STATIC, extension);
    }

    private static void add(HashSet set, String extension) {
        if (TextUtils.isEmpty((CharSequence)extension)) {
            return;
        }
        set.add(extension.replace(".", "").toLowerCase().trim());
    }

    private static void remove(HashSet set, String extension) {
        if (TextUtils.isEmpty((CharSequence)extension)) {
            return;
        }
        set.remove(extension.replace(".", "").toLowerCase().trim());
    }

    public boolean isMedia(String extension) {
        if (TextUtils.isEmpty((CharSequence)extension)) {
            return false;
        }
        if (NO_CACH.contains(extension)) {
            return true;
        }
        return this.no_cache.contains(extension.toLowerCase().trim());
    }

    public boolean canCache(String extension) {
        if (TextUtils.isEmpty((CharSequence)extension)) {
            return false;
        }
        if (STATIC.contains(extension = extension.toLowerCase().trim())) {
            return true;
        }
        return this.statics.contains(extension);
    }

    public CacheExtensionConfig addExtension(String extension) {
        CacheExtensionConfig.add(this.statics, extension);
        return this;
    }

    public CacheExtensionConfig removeExtension(String extension) {
        CacheExtensionConfig.remove(this.statics, extension);
        return this;
    }

    public boolean isHtml(String extension) {
        if (TextUtils.isEmpty((CharSequence)extension)) {
            return false;
        }
        return extension.toLowerCase().contains("html") || extension.toLowerCase().contains("htm");
    }

    public void clearAll() {
        this.clearDiskExtension();
    }

    public void clearDiskExtension() {
        this.statics.clear();
    }
}

