/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.core.web.cache.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.text.TextUtils;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NetUtils {
    public static boolean isConnected(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnected();
    }

    public static String getOriginUrl(String referer) {
        String string = referer;
        if (TextUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        try {
            URL uRL = new URL(string);
            int n = uRL.getPort();
            string = uRL.getProtocol() + "://" + uRL.getHost() + (n == -1 ? "" : ":" + n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public static Map<String, String> multimapToSingle(Map<String, List<String>> maps) {
        StringBuilder stringBuilder = new StringBuilder();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> entry : maps.entrySet()) {
            List<String> list = entry.getValue();
            stringBuilder.delete(0, stringBuilder.length());
            if (list != null && list.size() > 0) {
                for (String string : list) {
                    stringBuilder.append(string);
                    stringBuilder.append(";");
                }
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            }
            hashMap.put(entry.getKey(), stringBuilder.toString());
        }
        return hashMap;
    }
}

