/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.core.web.cache.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class TimeUtils {
    private static final String STARD_FROMAT = "yyyy-MM-dd HH:mm:ss";

    public static Date formatGMT(String time) {
        if (time.indexOf("GMT") < 0) {
            try {
                long l = Long.valueOf(time);
                return new Date(l * 1000L);
            }
            catch (Exception exception) {
                return null;
            }
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        try {
            Date date = simpleDateFormat.parse(time.trim());
            return date;
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            return null;
        }
    }

    public static boolean compare(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            return false;
        }
        return d1.getTime() - d2.getTime() > 0L;
    }

    public static Date getStardTime(String time) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(STARD_FROMAT);
        try {
            Date date = simpleDateFormat.parse(time);
            return date;
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            return null;
        }
    }

    public static Date getStardTime(Long time) {
        try {
            Date date = new Date(time * 1000L);
            return date;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static String getCurrentTime() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(STARD_FROMAT);
        return simpleDateFormat.format(new Date());
    }
}

