/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.core.web.webview;

import android.content.Context;
import android.content.MutableContextWrapper;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.MessageQueue;
import android.webkit.CookieManager;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.alimm.tanx.core.TanxCoreSdk;
import com.alimm.tanx.core.utils.LogUtils;
import java.util.Stack;

public class PreloadWebView {
    private static final int CACHED_WEB_VIEW_MAX_NUM = 2;
    private static final Stack<WebView> mCachedWebViewStack = new Stack();
    private Handler mainHandler;

    private PreloadWebView() {
    }

    public static PreloadWebView getInstance() {
        return Holder.INSTANCE;
    }

    public void preload() {
        LogUtils.d("webview preload", new String[0]);
        if (mCachedWebViewStack.size() < 2) {
            if (Looper.getMainLooper() == Looper.myLooper()) {
                this.pushCachedWebViewStack();
            } else {
                if (this.mainHandler == null) {
                    this.mainHandler = new Handler(Looper.getMainLooper());
                }
                this.mainHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        PreloadWebView.this.pushCachedWebViewStack();
                    }
                });
            }
        }
    }

    private void pushCachedWebViewStack() {
        Looper.myQueue().addIdleHandler(new MessageQueue.IdleHandler(){

            public boolean queueIdle() {
                LogUtils.d("PreloadWebView", "-->queueIdle");
                mCachedWebViewStack.push(PreloadWebView.this.createWebView());
                return false;
            }
        });
    }

    private WebView createWebView() {
        WebView webView = new WebView((Context)new MutableContextWrapper((Context)TanxCoreSdk.getApplication()));
        webView.getSettings().setJavaScriptEnabled(true);
        webView.loadDataWithBaseURL("file:///android_asset/article/?item_id=0&token=0", PreloadWebView.getHtml(), "text/html", "utf-8", "file:///android_asset/article/?item_id=0&token=0");
        return webView;
    }

    public static void loadBaseHtml(WebView webView) {
        if (webView == null) {
            return;
        }
        webView.loadDataWithBaseURL("file:///android_asset/article/?item_id=0&token=0", PreloadWebView.getHtml(), "text/html", "utf-8", "file:///android_asset/article/?item_id=0&token=0");
    }

    private static String getHtml() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<!DOCTYPE html>\n");
        stringBuilder.append("<html>\n");
        stringBuilder.append("<head>\n");
        stringBuilder.append("<meta charset=\"utf-8\">\n");
        stringBuilder.append("<meta name=\"viewport\" content=\"initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=no\">\n");
        stringBuilder.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"");
        stringBuilder.append("file:///android_asset/article/css/android.css");
        stringBuilder.append("\">\n</head>\n");
        stringBuilder.append("<body class=\"font_m\"><header></header><article></article><footer></footer>");
        stringBuilder.append("<script type=\"text/javascript\" src=\"");
        stringBuilder.append("file:///android_asset/article/js/lib.js");
        stringBuilder.append("\"></script>");
        stringBuilder.append("<script type=\"text/javascript\" src=\"");
        stringBuilder.append("file:///android_asset/article/js/android.js");
        stringBuilder.append("\" ></script>\n");
        stringBuilder.append("</body>\n");
        stringBuilder.append("</html>\n");
        return stringBuilder.toString();
    }

    public WebView getWebView(Context context) {
        if (mCachedWebViewStack == null || mCachedWebViewStack.isEmpty()) {
            WebView webView = this.createWebView();
            MutableContextWrapper mutableContextWrapper = (MutableContextWrapper)webView.getContext();
            mutableContextWrapper.setBaseContext(context);
            return webView;
        }
        WebView webView = mCachedWebViewStack.pop();
        MutableContextWrapper mutableContextWrapper = (MutableContextWrapper)webView.getContext();
        mutableContextWrapper.setBaseContext(context);
        this.initSettings(webView);
        return webView;
    }

    private void initSettings(WebView webView) {
        WebSettings webSettings = webView.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setDomStorageEnabled(true);
        webSettings.setAllowFileAccess(true);
        webSettings.setUseWideViewPort(true);
        webSettings.setLoadWithOverviewMode(true);
        webSettings.setSupportZoom(true);
        webSettings.setBuiltInZoomControls(false);
        webSettings.setDisplayZoomControls(false);
        webSettings.setDefaultTextEncodingName("UTF-8");
        if (Build.VERSION.SDK_INT >= 16) {
            webSettings.setAllowFileAccessFromFileURLs(true);
            webSettings.setAllowUniversalAccessFromFileURLs(true);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            CookieManager cookieManager = CookieManager.getInstance();
        }
        if (Build.VERSION.SDK_INT >= 21) {
            webSettings.setMixedContentMode(2);
        }
    }

    public void destroy() {
        if (mCachedWebViewStack != null) {
            mCachedWebViewStack.clear();
        }
    }

    private static class Holder {
        private static final PreloadWebView INSTANCE = new PreloadWebView();

        private Holder() {
        }
    }
}

