/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.ui;

import com.alimm.tanx.core.ad.config.TanxCoreConfig;
import com.alimm.tanx.core.net.INetWork;
import com.alimm.tanx.core.ut.AdUtAnalytics;
import com.alimm.tanx.core.ut.IUserTracker;
import com.alimm.tanx.ui.constant.SettingConfig;
import com.alimm.tanx.ui.image.ILoader;
import com.alimm.tanx.ui.image.ImageLoader;
import com.alimm.tanx.ui.player.cache.videocache.HttpProxyCacheServer;

public class TanxConfig
extends TanxCoreConfig {
    public ILoader mImageLoader;
    public SettingConfig mSettingConfig;
    public HttpProxyCacheServer proxyCacheServer;

    public TanxConfig() {
    }

    public TanxConfig(Builder builder) {
        this.setUserTrackerImpl(builder.mUserTrackerImpl);
        this.setDebugMode(builder.mDebugMode);
        this.setAppName(builder.mAppName);
        this.setChannel(builder.mChannel);
        this.setAppId(builder.mAppId);
        this.setAppName(builder.mAppName);
        this.setAppKey(builder.mAppKey);
        this.setAppSecret(builder.mAppSecret);
        this.setmOaid(builder.oaid);
        this.setImei(builder.imei);
        this.setOaidSwitch(builder.oaidSwitch);
        this.setImeiSwitch(builder.imeiSwitch);
        this.setIdAllSwitch(builder.idAllSwitch);
        this.mImageLoader = builder.mImageLoader;
        this.setImageLoader(builder.mImageLoader);
        this.mSettingConfig = builder.mSettingConfig;
    }

    public SettingConfig getSettingConfig() {
        return this.mSettingConfig;
    }

    public void setSettingConfig(SettingConfig settingConfig) {
        this.mSettingConfig = settingConfig;
    }

    public ILoader getImageLoader() {
        return this.mImageLoader;
    }

    public void setImageLoader(ILoader iLoader) {
        this.mImageLoader = iLoader;
        if (this.mImageLoader != null) {
            ImageLoader.setLoader(iLoader);
        }
    }

    public static class Builder {
        public IUserTracker mUserTrackerImpl = AdUtAnalytics.getInstance();
        public boolean mDebugMode = false;
        public String mAppName;
        public String mChannel;
        public String mAppId;
        public String oaid;
        public String imei;
        public boolean oaidSwitch;
        public boolean imeiSwitch;
        public boolean idAllSwitch;
        public INetWork mNetWork;
        public ILoader mImageLoader;
        public SettingConfig mSettingConfig = new SettingConfig();
        public String mAppKey;
        public String mAppSecret;

        public Builder debug(boolean bl) {
            this.mDebugMode = bl;
            return this;
        }

        public Builder appName(String string) {
            this.mAppName = string;
            return this;
        }

        public Builder channel(String string) {
            this.mChannel = string;
            return this;
        }

        public Builder appId(String string) {
            this.mAppId = string;
            return this;
        }

        public Builder network(INetWork iNetWork) {
            this.mNetWork = iNetWork;
            return this;
        }

        public Builder appKey(String string) {
            this.mAppKey = string;
            return this;
        }

        public Builder appSecret(String string) {
            this.mAppSecret = string;
            return this;
        }

        public Builder dark(SettingConfig settingConfig) {
            this.mSettingConfig = settingConfig;
            return this;
        }

        public Builder oaid(String string) {
            this.oaid = string;
            return this;
        }

        public Builder imei(String string) {
            this.imei = string;
            return this;
        }

        public Builder oaidSwitch(boolean bl) {
            this.oaidSwitch = bl;
            return this;
        }

        public Builder imeiSwitch(boolean bl) {
            this.imeiSwitch = bl;
            return this;
        }

        public Builder idAllSwitch(boolean bl) {
            this.idAllSwitch = bl;
            return this;
        }

        public Builder imageLoader(ILoader iLoader) {
            this.mImageLoader = iLoader;
            return this;
        }

        public TanxConfig build() {
            return new TanxConfig(this);
        }
    }
}

