/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.ui.player.cache;

import android.content.Context;
import com.alimm.tanx.core.utils.LogUtils;
import com.alimm.tanx.ui.player.cache.PreloadTask;
import com.alimm.tanx.ui.player.cache.ProxyCacheManager;
import com.alimm.tanx.ui.player.cache.videocache.HttpProxyCacheServer;
import com.alimm.tanx.ui.player.cache.videocache.PreloadListener;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class PreloadManager {
    public static final String TAG = "PreloadManager";
    public static PreloadManager sPreloadManager;
    public static final int PRELOAD_LENGTH = 0x100000;
    public ExecutorService mExecutorService = Executors.newSingleThreadExecutor();
    public LinkedHashMap<String, PreloadTask> mPreloadTasks = new LinkedHashMap();
    public boolean mIsStartPreload = true;
    public HttpProxyCacheServer mHttpProxyCacheServer;

    public PreloadManager(Context context) {
        this.mHttpProxyCacheServer = ProxyCacheManager.getProxy(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PreloadManager getInstance(Context context) {
        if (sPreloadManager != null) return sPreloadManager;
        Class<PreloadManager> clazz = PreloadManager.class;
        synchronized (PreloadManager.class) {
            if (sPreloadManager != null) return sPreloadManager;
            sPreloadManager = new PreloadManager(context.getApplicationContext());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sPreloadManager;
        }
    }

    public boolean deleteCacheFile(String string) {
        block3: {
            try {
                File file = ProxyCacheManager.getCacheFile(string);
                if (!file.exists()) break block3;
            }
            catch (Exception exception) {
                return false;
            }
            file.delete();
        }
        return true;
    }

    public void addPreloadTask(String string, PreloadListener preloadListener) {
        this.addPreloadTask(string, 0, -1, preloadListener);
    }

    public void addPreloadTask(String string, int n, int n2, PreloadListener preloadListener) {
        PreloadTask preloadTask;
        if (this.isPreloaded(string)) {
            if (preloadListener != null) {
                preloadListener.onCached(string);
            }
            return;
        }
        PreloadManager preloadManager = this;
        PreloadTask preloadTask2 = preloadTask;
        preloadTask2();
        preloadTask2.mRawUrl = string;
        preloadTask2.mPosition = n;
        preloadTask2.mPreloadLimit = n2;
        preloadTask2.mPreloadListener = preloadListener;
        preloadTask.mCacheServer = this.mHttpProxyCacheServer;
        LogUtils.i((String)TAG, (String)("addPreloadTask: " + n));
        preloadManager.mPreloadTasks.put(string, preloadTask2);
        if (preloadManager.mIsStartPreload) {
            preloadTask2.executeOn(this.mExecutorService);
        }
    }

    public boolean isPreloaded(String string) {
        Object object = ProxyCacheManager.getCacheFile(string);
        if (((File)object).exists()) {
            if (((File)object).length() >= 1024L) {
                return true;
            }
            ((File)object).delete();
            return false;
        }
        object = ProxyCacheManager.getTempCacheFile(string);
        if (((File)object).exists()) {
            return ((File)object).length() >= 0x100000L;
        }
        return false;
    }

    public void pausePreload(int n, boolean bl) {
        LogUtils.d((String)TAG, (String)("pausePreload\uff1a" + n + " isReverseScroll: " + bl));
        ((PreloadManager)((Object)iterator)).mIsStartPreload = false;
        Iterator<Map.Entry<String, PreloadTask>> iterator = ((PreloadManager)((Object)iterator)).mPreloadTasks.entrySet().iterator();
        while (iterator.hasNext()) {
            PreloadTask preloadTask = (PreloadTask)((Map.Entry)iterator.next()).getValue();
            if (bl) {
                if (preloadTask.mPosition < n) continue;
                preloadTask.cancel();
                continue;
            }
            if (preloadTask.mPosition > n) continue;
            preloadTask.cancel();
        }
    }

    public void resumePreload(int n, boolean bl) {
        LogUtils.d((String)TAG, (String)("resumePreload\uff1a" + n + " isReverseScroll: " + bl));
        this.mIsStartPreload = true;
        Iterator<Map.Entry<String, PreloadTask>> iterator = this.mPreloadTasks.entrySet().iterator();
        while (iterator.hasNext()) {
            PreloadTask preloadTask = iterator.next().getValue();
            if (bl) {
                if (preloadTask.mPosition >= n) continue;
                PreloadManager preloadManager = this;
                preloadManager.isPreloaded(preloadTask.mRawUrl);
                preloadTask.executeOn(preloadManager.mExecutorService);
                continue;
            }
            if (preloadTask.mPosition <= n) continue;
            PreloadManager preloadManager = this;
            preloadManager.isPreloaded(preloadTask.mRawUrl);
            preloadTask.executeOn(preloadManager.mExecutorService);
        }
    }

    public void continuePreLoad(int n, boolean bl) {
        LogUtils.d((String)TAG, (String)("resumePreload\uff1a" + n + " isReverseScroll: " + bl));
        this.mIsStartPreload = true;
        Iterator<Map.Entry<String, PreloadTask>> iterator = this.mPreloadTasks.entrySet().iterator();
        while (iterator.hasNext()) {
            PreloadTask preloadTask = iterator.next().getValue();
            if (bl) {
                if (preloadTask.mPosition >= n || this.isPreloaded(preloadTask.mRawUrl)) continue;
                preloadTask.executeOn(this.mExecutorService);
                continue;
            }
            if (preloadTask.mPosition <= n || this.isPreloaded(preloadTask.mRawUrl)) continue;
            preloadTask.executeOn(this.mExecutorService);
        }
    }

    public void removePreloadTask(String string) {
        PreloadTask preloadTask = this.mPreloadTasks.get(string);
        if (preloadTask != null) {
            preloadTask.cancel();
            this.mPreloadTasks.remove(string);
        }
    }

    public void removeAllPreloadTask() {
        Iterator<Map.Entry<String, PreloadTask>> iterator = ((PreloadManager)((Object)iterator)).mPreloadTasks.entrySet().iterator();
        while (iterator.hasNext()) {
            Iterator<Map.Entry<String, PreloadTask>> iterator2 = iterator;
            ((PreloadTask)((Map.Entry)iterator2.next()).getValue()).cancel();
            iterator2.remove();
        }
    }

    public void stopAllPreloadTask() {
        Iterator<Map.Entry<String, PreloadTask>> iterator = ((PreloadManager)((Object)iterator)).mPreloadTasks.entrySet().iterator();
        while (iterator.hasNext()) {
            ((PreloadTask)((Map.Entry)iterator.next()).getValue()).cancel();
        }
    }

    public String getPlayUrl(String string) {
        PreloadTask preloadTask = this.mPreloadTasks.get(string);
        if (preloadTask != null) {
            preloadTask.cancel();
        }
        if (this.isPreloaded(string)) {
            return this.mHttpProxyCacheServer.getProxyUrl(string);
        }
        return string;
    }
}

